#include "mbed.h"
#include <string>
#define toggle(a) {a=a^1;}

using namespace std;

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);  
Serial pc(USBTX, USBRX);


class Student {
    public:
        Student(){};
        Student(string n, int i): name(n), id(i){}  
        
        void setName(string n) { name = n; }
        void setName(char* n, int i){ name.assign(n, i );} 
        string getName() { return name; }
        
        void incId() { id++; } 
        int getId(){ return id; }
        
    private:
        string name;
        int id;
};

// Serial com
const int len = 64;
char inCmd[len];
bool inCmdReady = false;

// State machine 
enum {STARTUP, IDLE, ERROR, PRINTMAINMENU, CHANGENAME, NAMECHANGED, PRINTINFO};
int state(STARTUP);


void rxCallback() {
    static int idx = 0; 
    static int lastState=STARTUP;
    
    char c = pc.getc();    
    switch (c){      
        case '\n': 
            break;
        case '\r':
            inCmd[idx]='\0';
            idx=0; 
            if (lastState == STARTUP){
                state = IDLE;
                lastState = IDLE;
            }
            else if (lastState == IDLE) {
                if (inCmd[idx] == '0') {
                    state = CHANGENAME;
                    lastState = CHANGENAME;
                }
                else if (inCmd[idx] == '1'){
                    state = PRINTINFO;
                    lastState = IDLE;
                }
                else {
                    state = ERROR;
                    lastState = IDLE;
                }
            }
            else if (lastState == CHANGENAME){
                state = NAMECHANGED;
                lastState = IDLE;
            }
            break;       
        default:
            if(idx<len){
                inCmd[idx++] = c;
            }
            break;
    } 
}

void printMainMenu(){    
    pc.printf("\r\n[Main Menu]\r\nWhat would you like to do?\r\n");
    pc.printf("[0] change name\r\n");
    pc.printf("[1] print info\r\n");
}

void printInfo(Student &s){
    pc.printf(">> Name: %s  ID: %d\r\n", s.getName().c_str(), s.getId());        
}

int main() {
    string name=""; 
    
    pc.attach(&rxCallback, Serial::RxIrq); 
    wait(1);
    pc.printf("\r\n\r\n\r\n");
    pc.printf("Shalab - Tutorial_ClassIntro\r\n"); 
    pc.printf("Please enter your name: ");
    while (state != IDLE) { wait(0.1);} 
    
    name.assign(inCmd, strlen(inCmd) );       
    
    Student s(name, 0);
    pc.printf("\r\nhello %s, your id is %d\r\n", s.getName().c_str(), s.getId());
    
    printMainMenu();
    while (1) { 
        
        switch (state)
        {
            case CHANGENAME: 
                pc.printf("Please enter a new name: ");
                state = IDLE;
                break;
                
            case NAMECHANGED:
                s.setName(inCmd, sizeof(inCmd) ); 
                s.incId( );
                pc.printf(">> Your name has been set to %s\r\n", s.getName().c_str()); 
                printMainMenu();
                state = IDLE;
                break;
                
            case PRINTINFO:
                printInfo(s);  
                printMainMenu();
                state = IDLE;
                break;
                
            case ERROR:
                pc.printf(">> Error command\r\n");
                printMainMenu();
                state = IDLE;
                break;
                
            case IDLE:
                break;
                
            default:
                state = IDLE;
                break;
        }
         
        toggle(led1); 
        wait(0.10);
    };
   
}
