#include "mbed.h"
#include "common.h"
#include "VNH5019MC.h"
#include "Encoder_dspic33f.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
Serial pc(USBTX, USBRX);

// Motor
VNH5019MC motor(p19, p20, p21, p22);

// dspic Encoder 
const int enc_resolution = 10000 ;
const int address = 0x18 ;
Encoder_dspic33f encoder(p9, p10, enc_resolution, address);
Ticker printer;
Ticker sensorTicker;
Ticker positionControlTicker;
 
 
 
// Serial
const int len = 10;
char inCmd[len];
bool inCmdReady = false;

// control
double targetPos = 0; //rad 
double duty=0;
double dt = 0.005; 
double currentPos=0;
double currentSpeed=0;
int maxPower=20;

double K[3] = {17,1, 0.9};
    
double encoderData[2]; 
    
void readSensor(){    
    encoder.read(encoderData); 
}
    
void controlPos(){
    
    toggle(led4);
    double data[2];   
    double Kscale = 1; 
    
    static double lastPos=0; 
    static double ierror=0;
    double error=0;
    double derror=0;
    double currentVel;
     
    currentPos = encoderData[1];      
    currentVel = (currentPos - lastPos)/dt;
    lastPos = currentPos;
    error = (targetPos - currentPos);   // P
    limit(error, -10, 10);           
    derror = (0 - currentVel);          // D
    
    ierror += error;                    // I
    limit(ierror, -10, 10);           
    
    // feedback control 
    
    duty = Kscale*( K[0]*error + K[1]*ierror + K[2] *derror );
    limit(duty, -maxPower, maxPower);  
    motor.move(duty); 
}

void printdata()
{
    toggle(led3);  
    pc.printf("TargetPos (deg): %f  CurrentPos: %f Duty: %f maxPower: %d\r", 
    toDegrees(targetPos), toDegrees(encoderData[1]), duty, maxPower);   
}
 
 

double extractInt(char *buf)
{
    char tmp[10];
    double tmpDuty;
    strcpy(tmp, buf+1), 
    tmpDuty =atof(tmp);    
    return tmpDuty;
}

void rxCallback() {
            printer.detach();    
    static int idx = 0; 
    toggle(led2); 
    char c = pc.getc();    
    switch (c){      
        case '\n': 
            break;
        case '\r':
            inCmd[idx]='\0';
            idx=0;
            inCmdReady = true;  
            break;       
        default:
            if(idx<len){
                inCmd[idx++] = c;
            }
            break;
    } 
}

int main() {
    
    pc.baud(115200);   
    pc.attach(&rxCallback, Serial::RxIrq); 
    pc.printf("\r\n\r\n\r\n");
    pc.printf("Shalab - Tutorial06_motorPositionControl\r\n");  
    pc.printf("Command list:\r\n"
          "r: reset\r\n" 
          "p: print data\r\n"
          "t: set target position\r\n"
          "i: offline\r\n"
          "o: online\r\n"
          );
    encoder.set_resolution(enc_resolution); 
    encoder.reset();
    wait(1);
    
    //timer1Init(dt);
    sensorTicker.attach(&readSensor, dt);
    positionControlTicker.attach(&controlPos, dt);    
 
    
    while(1) { 
        toggle(led1); 
        if (inCmdReady)
        { 
            printer.detach();    
            switch (inCmd[0]){  
            case 'r':{
                pc.printf("Reset\r\n"); 
                positionControlTicker.detach();
                encoder.reset();
                wait(1);
                targetPos=0;
                positionControlTicker.attach(&controlPos, dt);
                break;} 
            case 'm':{ 
                maxPower = int(extractInt(inCmd));  
                break;} 
            case 't':
                targetPos = toRadians(extractInt(inCmd));
                pc.printf("Set target to %f\r\n", toDegrees(targetPos)); 
                break;
            case 'i':             
                pc.printf("offline\r\n");  
                positionControlTicker.detach();
                motor.stop();
                break; 
            case 'o':           
                pc.printf("online\r\n");      
                positionControlTicker.attach(&controlPos, dt); 
                break; 
            default:
                break;
            }
            inCmdReady = false;
            printer.attach(&printdata, 0.1); 
        } 
              
    }
}

