#include "mbed.h"
#include "VNH5019MC.h"

#define M1EN  p27
#define M1INA p23
#define M1INB p24
#define M1PWM p25

#define M2EN  p30
#define M2INA p28
#define M2INB p29
#define M2PWM p26

DigitalOut led1(LED1);
Serial pc(USBTX, USBRX);

// Motor
VNH5019MC motor1(M1EN, M1INA, M1INB, M1PWM);
//VNH5019MC motor2(M2EN, M2INA, M2INB, M2PWM);

int main() {
    pc.printf("\r\n\r\n\r\n");
    pc.printf("Shalab - Tutorial03_SimpleMotorControl\r\n");  
    
    int duty = 0;
    bool increment = true;
    
    while(1) { 
        if ( duty >= 100 ) increment = false;
        if ( duty <= -100) increment = true;
        if (increment) duty++;
        else duty--;
        
        motor1.move(duty);
        
        led1 = !led1;
        wait(0.05);
    }
}