#include "mbed.h"
#include "common.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);  
Serial pc(USBTX, USBRX);

typedef union bytes {
    double d ;
    char c[8];
}bytes;

void printDoubleToHex(double d){
    bytes b;
    b.d = d;
    pc.printf("double to hex:\r\n");
    pc.printf("%f -> %x %x %x %x %x %x %x %x\r\n", b.d, b.c[0], b.c[1], b.c[2], b.c[3], b.c[4], b.c[5], b.c[6], b.c[7]);
     
}


void printHexToDouble(char *arr){
    bytes b;
    for (int i=0; i<8; ++i)
        b.c[i] = arr[i]; 
    pc.printf("received hex: %x %x %x %x %x %x %x %x \r\n", b.c[0], b.c[1], b.c[2], b.c[3], b.c[4], b.c[5], b.c[6], b.c[7]);
    pc.printf("convert to: %f\r\n", b.d);
     
}

// Serial Interrupt
const int len = 64;
char inCmd[len];
bool inCmdReady = false;

void rxCallback() {
    static int idx = 0; 
    toggle(led2); 
    char c = pc.getc();           
    switch (c){      
        case '\n': 
            break;
        case '\r':
            inCmd[idx]='\0';
            idx=0;
            inCmdReady = true;  
            break;       
        default:
            if(idx<len){
                inCmd[idx++] = c;
            }
            break;
    }
}

int main() {
    pc.attach(&rxCallback, Serial::RxIrq); 
    pc.printf("\r\n\r\n\r\n");
    pc.printf("Shalab - Tutorial_BinarySerialCom\r\n");  
    
    while(1) {
        if (inCmdReady)
        {
            toggle(led3);
            printHexToDouble(inCmd); 
            inCmdReady = false;
        }
        toggle(led1);
        wait(0.1);
    }
}
