#include "mbed.h"
#include "common.h"


DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);  
Serial pc(USBTX, USBRX);


// globals
const int len = 64;
char inCmd[len];
bool inCmdReady = false;

void rxCallback() {
    static int idx = 0; 
    toggle(led2); 
    char c = pc.getc();    
    switch (c){      
        case '\n': 
            break;
        case '\r':
            inCmd[idx]='\0';
            idx=0;
            inCmdReady = true;  
            break;       
        default:
            if(idx<len){
                inCmd[idx++] = c;
            }
            break;
    } 
}


int main() {
    pc.printf("\r\n\r\n\r\n");
    pc.printf("Shalab - Tutorial_SerialUART\r\n");
    pc.printf("Echo test, max input length: 64 chars\r\n");
    pc.printf("> ");
    pc.attach(&rxCallback, Serial::RxIrq); 
     
    while(1) {
        toggle(led1);
        if (inCmdReady)
        {
            toggle(led2); 
            pc.printf("You've typed:\r\n  %s\r\n", inCmd); 
            pc.printf("\r\n> ");
            inCmdReady = false;
        }
         
        wait(0.50);
    }
}
