#include "mbed.h"
#include "mbed_genie.h"
 
Mbed4dGenie genie(PB9, PB10, PB11); 
DigitalOut led1(LED1);
DigitalOut led2(LED2);

bool winButton0Status = false; //holds the "status" of winButton0 object.
bool winButton1Status = false; //holds the "status" of winButton1 object.

int userLed0Status = 0; 
int userLed1Status = 0;
 
void myGenieEventHandler(void)  //Event handler for the 4d Systems display
{
    genieFrame Event;
    genie.genieDequeueEvent(&Event);
    
    //event report from an object
    if(Event.reportObject.cmd == GENIE_REPORT_EVENT) 
    {        
        if (Event.reportObject.object == GENIE_OBJ_WINBUTTON) // If the Reported Message was from a winbutton
        { 
            if (Event.reportObject.index == 0) 
            {
                if (winButton0Status == false) {
                    printf("Button 1 pressed\n\r");
                    printf("LED 1 is On now\n\r");                    
                    led1 = 1;
                    userLed0Status = 1;
                    winButton0Status = !winButton0Status;
                }
                
                 else if (winButton0Status == true) {
                    printf("Button 1 pressed\n\r");
                    printf("LED 1 is Off now\n\r");                    
                    led1 = 0;
                    userLed0Status = 0;
                    winButton0Status = !winButton0Status;
                }
            }
                
            if (Event.reportObject.index == 1) 
            {             
                if(winButton1Status == false) {
                    printf("Button 2 pressed\n\r"); 
                    printf("LED 2 is On now\n\r"); 
                    led2 = 1;
                    userLed1Status = 1;
                    winButton1Status = !winButton1Status;
                }

                else if(winButton1Status == true) {
                    printf("Button 2 pressed\n\r"); 
                    printf("LED 2 is Off now\n\r"); 
                    led2 = 0;
                    userLed1Status = 0;
                    winButton1Status = !winButton1Status;
                }

            }
            
        }
    }
}
 
int main()
 
{
    genie.Start();
    genie.genieAttachEventHandler(&myGenieEventHandler); // Call the event handler 
    
    printf("Syed's mbed Gecko board Winbutton-LED Demo \n\r");  // Display a welcome message on the serial monitor
 
    while(1) 
    
    {                                                  // initialise an infinite while loop
    
    genie.genieWriteObject(GENIE_OBJ_USER_LED,0,userLed0Status);      // Set the USERLED0 object high if button 0 is pressed
    genie.genieWriteObject(GENIE_OBJ_USER_LED,1,userLed1Status);      // Set the USERLED1 object high if button 1 is pressed
    
    wait(1);                                           // Wait one second      
    
    }
}