#include "mbed.h"
#include "ESP8266.h"
#include <string>

#define APIKEY V5N1NKKKH5T51D48    //Put "Write key" of your channel in thingspeak.com 
#define IP "184.106.153.149"       // IP Address of "api.thingspeak.com\"
#define WIFI_SSID "Jeremy"
#define WIFI_PASS "mbedproject"

Serial pc(USBTX, USBRX); // tx, rx
ESP8266 WiFi (D1, D0, 115200);

AnalogIn temp(A0);
DigitalOut test(D3, 0);
InterruptIn motion(D2);

void WiFi_Init (void);
void WiFi_Send (void);

char snd[255];
char rcv[1000];

int motion_cnt = 0;
int motion_detected = 0;
double tempC;
double tempF;
    
void irq_handler(void)
{
    motion_detected = 1;
}

int main(void)
{
    pc.baud(115200);
    pc.printf("Program Started \r\n");
    
    WiFi_Init();
    
    pc.printf("WiFi Connected! \r\n");
    
    //time_t is used to store the calender time format
    time_t rawtime;
    struct tm *timeinfo;
    
    motion.rise(&irq_handler);
    
    while(1)
    {
        tempC = (temp*300);
        tempF = (9.0*tempC)/5.0 + 32.0;
        
        pc.printf("Temperature is %.2f C %.2f F\n\r", tempC, tempF);
        
        wait(1);
        
        if(motion_detected)
        {
            //get the current time
            time(&rawtime);
            timeinfo = localtime(&rawtime);
            
            motion_cnt++;
            motion_detected = 0;
            pc.printf("Motion %d Detected at %d:%d:%d \n\r", motion_cnt, timeinfo->tm_hour, timeinfo->tm_min, timeinfo->tm_sec);
        }
        
        if(tempF > 90)
        {
            DigitalOut test(D3,1);
            
        }
        else
        {
         DigitalOut test(D3,0);
        }
        WiFi_Send();
    }
}

void WiFi_Init (void)
{
    pc.printf("Initializing ESP \r\n");

    pc.printf("Reset WiFi \r\n");
    WiFi.Reset();                   //RESET ESP
    WiFi.RcvReply(rcv, 400);        //receive a response from ESP
    pc.printf("%s \r\n", rcv);
    wait(2);

    strcpy(snd, "AT");
    WiFi.SendCMD(snd);
    pc.printf("%s \r\n", snd);
    WiFi.RcvReply(rcv, 400);
    pc.printf("%s \r\n", rcv);
    wait(2);

    strcpy(snd, "AT+CWMODE=1");
    WiFi.SendCMD(snd);
    pc.printf("%s \r\n", snd);
    WiFi.RcvReply(rcv, 400);
    pc.printf("%s \r\n", rcv);
    wait(2);

    strcpy(snd, "AT+CWJAP=\"");
    strcat(snd, WIFI_SSID);
    strcat(snd, "\",\"");
    strcat(snd, WIFI_PASS);
    strcat(snd, "\"");

    WiFi.SendCMD(snd);
    pc.printf("%s \r\n", snd);
    wait(2);
    WiFi.RcvReply(rcv, 400);
    pc.printf("%s \r\n", rcv);
    wait(2);

    strcpy(snd, "AT+CIPMUX=1");
    WiFi.SendCMD(snd);
    pc.printf("%s \r\n", snd);
    WiFi.RcvReply(rcv, 400);
    pc.printf("%s \r\n", rcv);
    wait(2);
}

void WiFi_Send (void)
{
    //ESP updates the Status of Thingspeak channel//

    strcpy(snd,"AT+CIPSTART=");
    strcat(snd,"\"TCP\",\"");
    strcat(snd,IP);
    strcat(snd,"\",80");

    WiFi.SendCMD(snd);
    pc.printf("Send\r\n%s",snd);
    WiFi.RcvReply(rcv, 1000);
    pc.printf("Receive\r\n%s",rcv);
    wait(1);

    sprintf(snd,"GET https://api.thingspeak.com/update?api_key=V5N1NKKKH5T51D48&field1=%f&field2=%d\r\n", tempF, motion_cnt);

    int i=0;
    for(i=0; snd[i]!='\0'; i++);
    i++;
    char cmd[255];

    sprintf(cmd,"AT+CIPSEND=%d",i);           //Send Number of open connection and Characters to send
    WiFi.SendCMD(cmd);
    pc.printf("Send\r\n%s",cmd);
    while(i<=20 || rcv == ">") {
        WiFi.RcvReply(rcv, 1000);
        wait(100);
        i++;
    }
    pc.printf("Receive\r\n%s",rcv);

    WiFi.SendCMD(snd);       //Post value to thingspeak channel
    pc.printf("Send\r\n%s",snd);

    while(i<=20 || rcv == "OK") {
        WiFi.RcvReply(rcv, 1000);
        wait(100);
        i++;
    }
    pc.printf("Receive\r\n%s",rcv);
}