// ----------------------------------------------------------------------------
// Copyright 2016-2018 ARM Ltd.
//
// SPDX-License-Identifier: Apache-2.0
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// ----------------------------------------------------------------------------
#ifndef MBED_TEST_MODE

#include "mbed.h"

NetworkInterface *net;

int main(void) {
    printf("Starting program, connecting to network\n");

    net = NetworkInterface::get_default_instance();
    nsapi_error_t status = net->connect();
    if (status != 0) {
        printf("Connecting to the network failed %d!\n", status);
        return -1; //should be something more "realistic approach", not this childlish behavior
    }
    printf("Connected to the network successfully. IP address: %s\n", net->get_ip_address());
    return 0;
}
#endif
