#ifndef MBED_I2CSLAVE_H
#define MBED_I2CSLAVE_H

#include "mbed.h"

#define ReadRequired 1
#define WriteRequired 2

namespace mbed {
    
class i2cslave : public I2CSlave
{
public:
    int8_t *Registar;
    int log[10];
    i2cslave(PinName sda, PinName scl, int8_t *Registar);
     
     void getdata();
     
    void attach(void (*fptr)(void));

    template<typename T>
    void attach(T* tptr, void (T::*mptr)(void)) {
        fp.attach(tptr, mptr);
        enable_attach();
    }
    
    void enable_attach();

    void disable_attach();

    static void func_call(uint32_t id, uint8_t addr, uint8_t state);
    
protected:
    FunctionPointer fp;    
    
};

}
 
#endif
