#include "i2cslave.h"

/*example*************************************************
#include "mbed.h"
#include "i2cslave.h"

#define ADDR 0x1D
#define _ADDR ADDR<<1   //on raspi

union U{
    int8_t _Registar[0x40];
    int32_t Registar[0x10];
};
union U u = { 0 };
i2cslave slave(p28, p27, u._Registar);
Serial PC(USBTX, USBRX);

int main()
{
    slave.address(_ADDR);
    while(1){
        PC.printf("%d, %d\r\n", u.Registar[0], u.Registar[1]);
        wait_ms(100);
    }
}
**********************************************************/

#if DEVICE_I2CSLAVE

namespace mbed {

i2cslave* instance;

i2cslave::i2cslave(PinName sda, PinName scl, int8_t *_Registar) : I2CSlave(sda, scl)
{
    frequency(400000);
    i2cslave::attach(this, &i2cslave::getdata);
    Registar = _Registar;
}

void i2cslave::getdata( void )
{
    if(I2CSlave::receive()==I2CSlave::WriteAddressed)
    {
        char DATA[3] = {}; 
        I2CSlave::read(DATA, 3);
        char reg=DATA[0];
        char size =DATA[1];
        char cmd = DATA[2];
        char X[size];
        for(int i = 0; i < size; i++)X[i] = 0;
        int8_t tmp = 0;
        //wait_us(50);  //to mbed devices
        wait_us(500);   //to RaspberryPi
        switch(cmd)
        {
            case ReadRequired:
                I2CSlave::read(X, size);
                for(int i = 0; i < size; i++)
                {
                    *(Registar+reg*4+i) = X[i];
                }
                break;

            case WriteRequired:
                I2CSlave::read(DATA, 1);    //捨て受信
                
                int8_t tmp = *(Registar+reg);
                I2CSlave::write(tmp);
                I2CSlave::write(tmp);
                I2CSlave::write(tmp);
                break;
        }
    }
}
void i2cslave::attach(void (*fptr)(void)) {
    fp.attach(fptr);
    enable_attach();
}

void i2cslave::func_call(uint32_t id, uint8_t addr, uint8_t state) {
    instance->fp.call();
}

void i2cslave::enable_attach() {
    instance = this;
    //NVIC_SetVector(I2C_IRQn, (uint32_t)(&i2cslave::func_call));   //lpc1114
    NVIC_SetVector(I2C2_IRQn, (uint32_t)(&i2cslave::func_call));    //lpc1768 (pin28, pin27)
    NVIC_EnableIRQ(I2C2_IRQn);    
}

void i2cslave::disable_attach() {
    //NVIC_DisableIRQ(I2C_IRQn);    //lp1114
    NVIC_DisableIRQ(I2C2_IRQn);    //lpc1768 (pin28, pin27)
}

}

#endif
