#include "i2cslave.h"

/*example*************************************************

#include "mbed.h"
#include "i2cslave.h"

int32_t Registar[0x20];
i2cslave i2c(p28, p27, Registar);
    
int main()
{
    i2c.address(0xa0);
    Registar[10] = 0;
    while(1)
    {
        printf("%d\r\n", Registar[0]);
        Registar[1] = 1234;
        wait_ms(500);
        Registar[1] = 5678;
        wait_ms(500);
    }
}

**********************************************************/

#if DEVICE_I2CSLAVE

namespace mbed {

i2cslave* instance;

i2cslave::i2cslave(PinName sda, PinName scl, int32_t *_Registar) : I2CSlave(sda, scl)
{
    frequency(400000);
    i2cslave::attach(this, &i2cslave::getdata);
    Registar = _Registar;
}

void i2cslave::getdata( void )
{
    if(I2CSlave::receive()==I2CSlave::WriteAddressed)
    {
        char DATA[2] = {}; 
        I2CSlave::read(DATA,2);
        char reg=DATA[0];
        char num =DATA[1]; 
        char X[num];
        for(int i = 0; i < num; i++)X[i] = 0;
        int32_t tmp = 0;
        wait_us(50);
        switch(I2CSlave::receive())
        {
            case 0 :break;
            case I2CSlave::ReadAddressed:
            {
                int32_t tmp = *(Registar+reg);
                for(int i = 0; i < num; i++)
                {
                    X[i] = (tmp >> i*8) & 0xFF;
                }
                I2CSlave::write(X,num);
                break;
            }
            case I2CSlave::WriteGeneral:break;
            case I2CSlave::WriteAddressed:
            {
                I2CSlave::read(X, num);
                for (int i=0; i < num; i++)
                {
                    tmp |= X[i] << (i*8);
                }
                *(Registar+reg) = tmp;
                break;
            }
        }
    }
}
void i2cslave::attach(void (*fptr)(void)) {
    fp.attach(fptr);
    enable_attach();
}

void i2cslave::func_call(uint32_t id, uint8_t addr, uint8_t state) {
    instance->fp.call();
}

void i2cslave::enable_attach() {
    instance = this;
    NVIC_SetVector(I2C_IRQn, (uint32_t)(&i2cslave::func_call));   //lpc1114
    //NVIC_SetVector(I2C2_IRQn, (uint32_t)(&i2cslave::func_call));    //lpc1768 (pin28, pin27)
    NVIC_EnableIRQ(I2C_IRQn);    
}

void i2cslave::disable_attach() {
    NVIC_DisableIRQ(I2C_IRQn);    //lp1114
    //NVIC_DisableIRQ(I2C2_IRQn);    //lpc1768 (pin28, pin27)
}

}

#endif
