#include "i2cmaster.h"

i2c::i2c(PinName sda, PinName scl) : I2C(sda, scl)
{
    frequency(400000);
}

void i2c::sendi2c(char addr, char registar, int data, int size)
{
    if(size > 0)             size = size;
    else if(data > 0xFFFFFF) size = 4;
    else if(data > 0xFFFF)   size = 3;
    else if(data > 0xFF)     size = 2;
    else                     size = 1;
    char DATA[4] = {data & 0xFF, (data>>8) & 0xFF, (data>>16) & 0xFF, (data>>24) & 0xFF};
    char i2cData[3] = {size, registar, SendData};
    write(addr, i2cData, 3);
    write(addr, DATA, size);
}

int i2c::getSlaveData(char addr, char registar, int size)
{
    char i2cData[3] = {size, registar, RequestData};
    char getData[12] = {};
    write(addr, i2cData, 3);
    read(addr, getData, size);
    return getData[0] | (getData[1] << 8) | (getData[2] << 16) | (getData[3] << 24);
}