#ifndef MY_DEFINE_H
#define MY_DEFINE_H

#define PI 3.141592654

float DEG_TO_RAD = PI/180.0;
float RAD_TO_DEG = 180.0/PI;

float wheel_d = 0.127;           // メカナム直径[mm]
float wheel_r = 0.0635;
float deg_per_pulse = 0.0072;   // ステッピングモータ(AR46SAK-PS50-1)

// 目標位置到達判定
float threshold_x     = 5; //[mm]
float threshold_y     = 5; //[mm]
float threshold_theta = 1 * DEG_TO_RAD;

/*Common for Master and Slave***************/

typedef enum
{
    RightForward    = 1,
    LeftForward     = 2,
    RightBack       = 3,
    LeftBack        = 4
}MotorPosition;

typedef enum
{
    COAST   = 0,
    BRAKE   = 1,    
    CW      = 2,
    CCW     = 3
}MotorState;

#define WHO_AM_I        0x00
#define MY_IIC_ADDR     0x01
#define MOTOR_DIR       0x04
#define PWM_FREQUENCY   0x05


/*Master only**************************************/

#define MOTOR_NUM 4
#define IIC_ADDR1        0xB0
#define IIC_ADDR2        0xC0
#define IIC_ADDR3        0xD0
#define IIC_ADDR4        0xE0

#define MaxFrequency   70000
#define MinFrequency   0//50

// Register Map from PC
#define MARKER_X        0x05
#define MARKER_Y        0x06
#define MARKER_Z        0x07
#define MARKER_ROLL     0x08
#define MARKER_PITCH    0x09
#define MARKER_YAW      0x010

#endif
