/*Common for Master and Slave***************/

typedef enum
{
    RightForward    = 1,
    LeftForward     = 2,
    RightBack       = 3,
    LeftBack        = 4
}MotorPosition;

typedef enum
{
    COAST   = 0,
    BRAKE   = 1,    
    CW      = 2,
    CCW     = 3
}MotorState;

#define WHO_AM_I        0x00
#define MY_IIC_ADDR     0x01
#define MOTOR_DIR       0x04
#define PWM_FREQUENCY   0x05


/*Master only**************************************/

#define MOTOR_NUM 4
#define IIC_ADDR1        0xB0
#define IIC_ADDR2        0xC0
#define IIC_ADDR3        0xD0
#define IIC_ADDR4        0xE0

#define MaxFrequency   70000
#define MinFrequency   0//50

// Register Map from PC
#define MARKER_X        0x05
#define MARKER_Y        0x06
#define MARKER_Z        0x07
#define MARKER_ROLL     0x08
#define MARKER_PITCH    0x09
#define MARKER_YAW      0x010

#define PI 3.141592654