#include "mbed.h"
#include "i2cslave.h"
#include "define.h"


// define IIC_ADDR 1:0xB0, 2:0xC0, 3:0xD0 or 4:0xD0
// define I_AM but it not used. 
#define IIC_ADDR        0xB0
#define I_AM            RightForward

int32_t Register[0x20] = {};
i2cslave i2c(dp5, dp27, Register);
 
int main()
{
    Register[WHO_AM_I] = I_AM;
    Register[MY_IIC_ADDR] = IIC_ADDR;
    
    Register[MOTOR_DIR] = COAST;
    
    PwmOut PWM_PIN(dp24);
    DigitalOut PWM_ENABLE(dp14);
    DigitalOut DIR_PIN(dp18);
    DigitalOut CON_PIN(dp17);
    
    DIR_PIN = 0;
    CON_PIN = 0;
    
    i2c.address(IIC_ADDR);
    
    float f = 1000;
    float T = 0.05;
    float T_last = T;
    PWM_PIN = 0;
    int dir = COAST;
    int last_dir = 0;
    
    while(1)
    {
        T_last = T;
        f = float(Register[PWM_FREQUENCY]);
        if(f > 0 && f <= 1000000) T = 1.0 / f;
        if(T_last != T) PWM_PIN.period(T);
        
        last_dir = dir;
        dir = Register[MOTOR_DIR];
        
        if(dir != last_dir)
        {
            switch(dir)
            {
                case COAST:
                    PWM_ENABLE = 0;
                    CON_PIN = 0;
                    break;
                case BRAKE:
                    CON_PIN = 1;
                    PWM_ENABLE = 1;
                    PWM_PIN = 0; 
                    break;
                case CW:
                    CON_PIN = 1;
                    DIR_PIN = 0;
                    PWM_ENABLE = 1;
                    PWM_PIN = 0.5;
                    break;
                case CCW:
                    CON_PIN = 1;
                    DIR_PIN = 1;
                    PWM_ENABLE = 1;
                    PWM_PIN = 0.5;
                    break;
            }
        }
    }
}