#ifndef USUSAMA_PROTOCOL_H
#define USUSAMA_PROTOCOL_H

#include "mecanum_controller.hpp"
//#include <vector>
//#include <optional>

static class UsusamaProtocol
{
    public:
    struct MoveCommand_t
    {
        float x;
        float y;
        float theta;
        bool enable;
    };
    struct MoveReply_t
    {
      float x;
      float y;
      float theta;
      bool reached;
    };
    struct StopCommand_t
    {
        bool stop;
    };
    struct StopReply_t
    {
        Pose2D pose;
        bool is_stop;
    };
    
    UsusamaProtocol()
    {
    }
    
    static int encode_float2int(float val)
    {
      return (int)(val * 1000);
    }
    static float decode_int2float(int val)
    {
      return (float)val / 1000;
    }
    
    public:
    static const uint8_t COMMAND_MOVE =        0x04;
    static const uint8_t COMMAND_POSE_X =      0x05;
    static const uint8_t COMMAND_POSE_Y =      0x06;
    static const uint8_t COMMAND_POSE_THETA =  0x07;
    
    static const uint8_t COMMAND_STOP =        0x08;
    
    static const uint8_t REPLY_MOVE =          0x04;
    static const uint8_t REPLY_COMMAND_X =        0x05;
    static const uint8_t REPLY_COMMAND_Y =        0x06;
    static const uint8_t REPLY_COMMAND_THETA =    0x07;
    static const uint8_t REPLY_STOP =          0x08;
    static const uint8_t REPLY_STATE_X = 0x010;
    static const uint8_t REPLY_STATE_Y = 0x011;
    static const uint8_t REPLY_STATE_THETA = 0x12;
    
    static const uint8_t DEBUG_CONSOLE = 0x20;
};

#endif