#ifndef QEI_H
#define QEI_H

#include "mbed.h"

class QEI {

public:
    
    QEI(PinName A, PinName B, int ppr);
    QEI(PinName A, PinName B, PinName Z, int ppr);
    QEI(PinName A, PinName B, int ppr, Timer *timer);
    QEI(PinName A, PinName B, PinName Z, int ppr, Timer *timer);
    
    float getDegree();
    float getSpeed();
    bool IsInterruptZ();

private:

    void init();
    void encode(void);
    void encodeZ();
    
    InterruptIn channelA;
    InterruptIn channelB;
    InterruptIn channelZ;
    Timer *_timer;
    
    float angle;
    int currState;
    int prevState;
    int position;
    float _ppr;
    
    bool _IsInterrupt;
};

#endif
