#include "PacketSerial.h"

/*sample code coudinator**********************************
#include "mbed.h"
#include "PacketSerial.h"

int32_t Registar[128] = {};
PacketSerial device(p13, p14, Registar);

int main()
{
    int32_t i = 0;
    while(1)
    {
        i++;
        device.writeData(i, 0x10);
        //wait_ms(100);
    }
}
*********************************************************/

/*sample code router**************************************
#include "mbed.h"
#include "PacketSerial.h"

int32_t Registar[128] = {};
PacketSerial device(p13, p14, Registar);

int main()
{
    while(1)
    {
        printf("%d\r\n", Registar[0x10]);
    }
}
*********************************************************/


PacketSerial::PacketSerial(PinName tx, PinName rx, int32_t* registar, int baudrate) : Serial(tx, rx)
{
    _registar = registar;
    Serial::baud(baudrate);
    Serial::attach(this, &PacketSerial::readData, Serial::RxIrq);
}

void PacketSerial::writeData(int32_t data, uint8_t reg)
{
    uint8_t dataBytes[4] =
    {
        (data >> 24) & 0xFF,
        (data >> 16) & 0xFF,
        (data >>  8) & 0xFF,
        (data >>  0) & 0xFF
    };

    Serial::putc(HEAD_BYTE);
    Serial::putc(reg);
    uint8_t checksum = 0;
    for (uint8_t i = 0; i < 4; ++i)
    {
        if ((dataBytes[i] == ESCAPE_BYTE) || (dataBytes[i] == HEAD_BYTE))
        {
            Serial::putc(ESCAPE_BYTE);
            checksum += ESCAPE_BYTE;
            Serial::putc(dataBytes[i] ^ ESCAPE_MASK);
            checksum += dataBytes[i] ^ ESCAPE_MASK;
        }
        else
        {
            Serial::putc(dataBytes[i]);
            checksum += dataBytes[i];
        }
    }

    // 末尾にチェックサムを追加で送信する
    Serial::putc(checksum);
}

void PacketSerial::writeFloatData(float data, uint8_t reg)
{
  int integer = (int)data;
  uint32_t decimal = (uint32_t)((data-integer)*1000000);
  writeData(integer, reg);
  writeData(decimal, reg+1);
}

float PacketSerial::getFloatData(uint8_t reg)
{
  return *(_registar + reg) + ((float)*(_registar + reg+1))/1000000;
}

void PacketSerial::readData()
{
    uint8_t bytes[4] = {0,0,0,0};
    int8_t checksum = 0;
    wait_us(500);
    uint8_t data = Serial::getc();
    wait_us(500);

    if (data == HEAD_BYTE)
    {
        uint8_t reg = Serial::getc();
        for (int i = 0; i < 4; ++i)
        {
            uint8_t d = Serial::getc();
            wait_us(500);
            if (d == ESCAPE_BYTE)
            {
                uint8_t nextByte = Serial::getc();
                bytes[i] = nextByte ^ ESCAPE_MASK;
                checksum += (d + nextByte);
            }
            else
            {
                bytes[i] = d;
                checksum += d;
            }
        }
        int8_t checksum_recv = Serial::getc();
        wait_us(500);
        int32_t DATA = 0x00;
        for(int i = 0; i < 4; i++)
        {
            DATA |= (((int32_t)bytes[i]) << (24 - (i*8)));
        }

        if (checksum == checksum_recv)
        {
            *(_registar + reg) =  DATA;
        }
        else
        {
            // data error
        }
    }
}