#ifndef SERIAL_H
#define SERIAL_H
#include "mbed.h"

#define HEAD_BYTE 0x7E
#define ESCAPE_BYTE 0x7D
#define ESCAPE_MASK 0x20

class PacketSerial : public Serial
{
    public:
    PacketSerial(PinName tx, PinName rx, int32_t* registar, int baudrate = 115200);
    void writeData(int32_t data, uint8_t reg);
    void writeFloatData(float data, uint8_t reg);    
    float getFloatData(uint8_t reg);
    
    private:
    void readData();
    int32_t* _registar;
};

#endif