#ifndef PID_H
#define PID_H
#include "mbed.h"

/*sample code

*/

class PID
{
    public:
        PID(Timer *T);
        
        float controlP(float target, float current, float new_Kp);
        float controlPI(float target, float current);
        float controlPID(float target, float current);
        
        void setParameter(float new_Kp, float new_Ki, float new_Kd);
        void setParameter(float new_Ku, float new_Pu);
        void setParameterPI(float new_Ku, float new_Pu);
        void reset();

        float Ku;
        float Pu;
        float Kp;
        float Ti;
        float Td;
        float Ki;
        float Kd;
        
        private:
        Timer *timer;
        float integral;
        float last_error;
        float current_time;
        float last_time;
};

#endif