#ifndef PID_H
#define PID_H
#include "mbed.h"

class PID
{
    public:
        PID(Timer *T);
        float controlPID(float target, float nowrpm);
        float PI_lateD(float target, float nowrpm);
        float controlP(float target, float nowrpm, float new_Kp);
        float controlPI(float target, float nowrpm);
        void setParameter(float new_Kp, float new_Ki, float new_Kd);
        void setParameter(float new_Ku, float new_Pu);
        void setParameterPI(float new_Ku, float new_Pu);
        void reset();

        float Ku;
        float Pu;
        float Kp;
        float Ti;
        float Td;
        float Ki;
        float Kd;
        
        private:
        Timer *timer;
        float integral;
        float prev_hensa;
        float nowtime;
        float prev_time;
        float lateD;
};

#endif