#include "MultiSerial.h"

MultiSerial::MultiSerial(PinName TX, PinName RX) : Serial(TX, RX)
{
}

double MultiSerial::getc()
{
    UNION obj;
    for(int i = 0; i < 8; i++)
    {
        obj.c[i] = Serial::getc();
    }
    return obj.d;
}

void MultiSerial::putc(double data)
{
    UNION obj;
    obj.d = data;
    for(int i = 0; i < sizeof(data); i++)
    {
        Serial::putc(obj.c[i]);
    }
}