#ifndef MOTORCONTROLER_H
#define MOTORCONTROLER_H
#include "mbed.h"

#define FLIP_MOTOR_DIR 0

typedef enum{
    CW = 0,
    CCW = 1,
}MotorDirection;

typedef enum{
    SM = 0,
    LAP = 1,
}ControlType;

class MotorControler
{
    public:
    MotorControler(PinName DIR, PinName PWM, PinName nSLP, ControlType control_type=SM);
    float operator = (float speed);
    float operator + (float speed);
    float operator += (float speed);
    float operator - (float speed);
    float operator -= (float speed);
    float operator * (float val);
    float operator *= (float val);
    float operator / (float val);
    float operator /= (float val);
    
    virtual void enableDriver(){}
    virtual void disableDriver(){}
    
    // speed(-1.0 - 1.0)
    void setSpeed(float speed);
    
    // dir(CW, or CCW)
    void setMotorDirection(MotorDirection dir);
    void setPinUsingSignMagnitude(int8_t dir, float speed);
    void setPinusingLockedUntiPhase(int8_t dir, float speed);
    
    // set PWM frequency
    // frequency[Hz]
    void setPwmFrequency(float frequency);
    
    protected:
    // if you want use LAP control, change DigitalOut -> PwmOut DIR_
    DigitalOut DIR_;
    PwmOut PWM_;
    DigitalOut nSLP_;
    uint8_t reverse_direction_;
    ControlType control_type_;
    float current_speed_;
};

class POLOLUControler : public MotorControler
{
    public:
    POLOLUControler(PinName DIR, PinName PWM, PinName nSLP, ControlType control_type=SM) : MotorControler(DIR, PWM, nSLP, control_type)
    {
    }
    
    virtual void enableDriver()
    {
        nSLP_ = 1;
    }
    
    virtual void disableDriver()
    {
        nSLP_ = 0;
    }
    
    using MotorControler::operator=;
    using MotorControler::operator+;
    using MotorControler::operator+=;
    using MotorControler::operator-;
    using MotorControler::operator-=;
    using MotorControler::operator*;
    using MotorControler::operator*=;
    using MotorControler::operator/;
    using MotorControler::operator/=;
};


class TEXNITISControler : public MotorControler
{
    public:
    TEXNITISControler(PinName DIR, PinName PWM, PinName nSLP, ControlType control_type=SM) : MotorControler(DIR, PWM, nSLP, control_type)
    {
        nSLP_ = 1;
    }
    
    virtual void enableDriver()
    {
        // do nothing;
    }
    
    virtual void disableDriver()
    {
        PWM_ = 0;
    }
    
    using MotorControler::operator=;
    using MotorControler::operator+;
    using MotorControler::operator+=;
    using MotorControler::operator-;
    using MotorControler::operator-=;
    using MotorControler::operator*;
    using MotorControler::operator*=;
    using MotorControler::operator/;
    using MotorControler::operator/=;
};


#endif