#ifndef MBED_JY901_H
#define MBED_JY901_H

#include "mbed.h"

/*example*************************************
#include "mbed.h"
#include "JY901.h"

I2C myi2c(p28, p27);
JY901 jy901(&myi2c);

int main()
{
    float angle = 0;
    jy901.calibrateAll(5000);
    while(1)
    {
        angle = jy901.getZaxisAngle();
        printf("%f\r\n", angle);
    }
}
**********************************************/

#define IICADDR     0xa0 // IIC address 
#define g           9.80665  // Acceleration of gravity

//#define SAVE        0x00 // Save 
#define CALSW       0x01 // Calibration
#define RSW         0x02 // Return data content
#define RATE        0x03 // Return data Speed
#define BAUD        0x04 // Baud rate
#define AXOFFSET    0x05 // X axis Acceleration bias
#define AYOFFSET    0x06 // Y axis Acceleration bias 
#define AZOFFSET    0x07 // Z axis Acceleration bias
#define GXOFFSET    0x08 // X axis angular velocity bias
#define GYOFFSET    0x09 // Y axis angular velocity bias 
#define GZOFFSET    0x0a // Z axis angular velocity bias
#define HXOFFSET    0x0b // X axis Magnetic bias 
#define HYOFFSET    0x0c // Y axis Magnetic bias 
#define HZOFFSET    0x0d // Z axis Magnetic bias 
#define D0MODE      0x0e // D0 mode 
#define D1MODE      0x0f // D1 mode 
#define D2MODE      0x10 // D2 mode 
#define D3MODE      0x11 // D3 mode 
#define D0PWMH      0x12 // D0PWM High-level width
#define D1PWMH      0x13 // D1PWM High-level width 
#define D2PWMH      0x14 // D2PWM High-level width 
#define D3PWMH      0x15 // D3PWM High-level width 
#define D0PWMT      0x16 // D0PWM Period
#define D1PWMT      0x17 // D1PWM Period 
#define D2PWMT      0x18 // D2PWM Period   
#define D3PWMT      0x19 // D3PWM Period 
#define LEDOFF      0x1b // Turn off LED 
#define GPSBAUD     0x1c // GPS baud rate

#define YYMM        0x30 // Year、Month
#define DDHH        0x31 // Day、Hour 
#define MMSS        0x32 // Minute、Second 
#define MS          0x33 // Millisecond
#define AX          0x34 // X axis Acceleration 
#define AY          0x35 // Y axis Acceleration
#define AZ          0x36 // Z axis Acceleration 
#define GX          0x37 // X axis angular velocity
#define GY          0x38 // Y axis angular velocity 
#define GZ          0x39 // Z axis angular velocity 
#define HX          0x3a // X axis Magnetic 
#define HY          0x3b // Y axis Magnetic 
#define HZ          0x3c // Z axis Magnetic 
#define Roll        0x3d // X axis Angle
#define Pitch       0x3e // Y axis Angle 
#define Yaw         0x3f // Z axis Angle 
#define TEMP        0x40 // Temperature
#define D0Status    0x41 // D0Status 
#define D1Status    0x42 // D1Status 
#define D2Status    0x43 // D2Status 
#define D3Status    0x44 // D3Status 
#define PressureL   0x45 // Pressure Low Byte 
#define PressureH   0x46 // Pressure High Byte 
#define HeightL     0x47 // Height Low Byte 
#define HeightH     0x48 // Height High Byte 
#define LonL        0x49 // Longitude Low Byte 
#define LonH        0x4a // Longitude High Byte 
#define LatL        0x4b // Latitude Low Byte 
#define LatH        0x4c // Latitude High Byte 
#define GPSHeight   0x4d // GPS Height 
#define GPSYaw      0x4e // GPS Yaw 
#define GPSVL       0x4f // GPS speed Low byte 
#define GPSVH       0x50 // GPS speed High byte 
#define Q0          0x51 // Quaternion Q0 
#define Q1          0x52 // Quaternion Q1 
#define Q2          0x53 // Quaternion Q2 
#define Q3          0x54 // Quaternion Q3

class JY901
{
    public:
    JY901(I2C *i2c);
    JY901(I2C *i2c, Timer *t);
    
    /****************************************/
    //not recommended
    //used only me
    float calculateAngleOnlyGyro();
    void reset();
    /****************************************/

    void calibrateGyroAccel();
    void calibrateMagnetic();
    void calibrateHeight();
    void endCalibrate();
    void calibrateAll(int time_ms);
    int getYear();
    int getMonth();
    int getDay();
    int getHour();
    int getMinute();
    int getSecond();
    int getMillisecond();
    float getXaxisAcceleration();
    float getYaxisAcceleration();
    float getZaxisAcceleration();
    float getXaxisAngularVelocity();
    float getYaxisAngularVelocity();
    float getZaxisAngularVelocity();
    float getXaxisMagnetic();
    float getYaxisMagnetic();
    float getZaxisMagnetic();
    float getXaxisAngle();
    float getYaxisAngle();
    float getZaxisAngle();
    float getTemperature();
    float getD0Status();
    float getD1Status();
    float getD2Status();
    float getD3Status();
    
    /*dnt use   I correct someday*********/
    float getPressure();
    float getHeight();
    float getLongitude();
    float getLatitude();
    float getGPSHeight();
    float getGPSYaw();
    float getGPSspeed();
    /*************************************/
    
    private:
    char *getdata(char registar);
    float s16(int dataL, int dataH);
    
    float last_time, time, dt;
    float gyroZ[3];
    float angleZ;
    
    I2C *_i2c;
    Timer *_timer;
};

#endif