#include "JY901.h"

JY901::JY901(I2C *i2c)
{
    _i2c = i2c;
}
JY901::JY901(I2C *i2c, Timer *timer)
{
    _i2c = i2c;
    _timer = timer;
    angleZ = 0;
    for(int i = 0; i < 3; i++)  gyroZ[i] = 0;
    _timer->start();
    last_time = 0;
    time = _timer->read();
}

float JY901::calculateAngleOnlyGyro()
{
    last_time = time;
    time = _timer->read();
    for(int i = 2; i > 0; i--)
    {
        gyroZ[i] = gyroZ[i-1];
    }
    gyroZ[0] = getZaxisAngularVelocity();
    dt = time - last_time;
    if( gyroZ[0] + gyroZ[2] != 0 )
        angleZ += gyroZ[1] * dt;
    return angleZ;
}

void JY901::reset()
{
    time = _timer->read();
    for(int i = 0; i > 2; i++)
    {
        gyroZ[i] = 0;
    }
}

void JY901::calibrateGyroAccel()
{
    _i2c->start();
    _i2c->write(IICADDR);
    _i2c->write(CALSW);
    _i2c->write(0x01);
    _i2c->write(0x00);
    _i2c->stop();
}

void JY901::calibrateMagnetic()
{
    _i2c->start();
    _i2c->write(IICADDR);
    _i2c->write(CALSW);
    _i2c->write(0x02);
    _i2c->write(0x00);
    _i2c->stop();
}

void JY901::calibrateHeight()
{
    _i2c->start();
    _i2c->write(IICADDR);
    _i2c->write(CALSW);
    _i2c->write(0x03);
    _i2c->write(0x00);
    _i2c->stop();
}

void JY901::endCalibrate()
{
    _i2c->start();
    _i2c->write(IICADDR);
    _i2c->write(CALSW);
    _i2c->write(0x00);
    _i2c->write(0x00);
    _i2c->stop();   
}

void JY901::calibrateAll(int time_ms)
{
    calibrateGyroAccel();
    calibrateMagnetic();
    calibrateHeight();
    wait_ms(time_ms);
    endCalibrate();
}

int JY901::getYear()
{
    char *data = getdata(YYMM);
    return (int)(*data);
}

int JY901::getMonth()
{
    char *data = getdata(YYMM);
    return (int)(*(data+1));
}

int JY901::getDay()
{
    char *data = getdata(DDHH);
    return (int)(*data);
}

int JY901::getHour()
{
    char *data = getdata(DDHH);
    return (int)(*(data+1));
}

int JY901::getMinute()
{
    char *data = getdata(MMSS);
    return (int)(*data);
}

int JY901::getSecond()
{
    char *data = getdata(MMSS);
    return (int)(*(data+1));
}

int JY901::getMillisecond()
{
    char *data = getdata(MS);
    return (int)((*(data+1) << 8) | *data);
}

float JY901::getXaxisAcceleration()
{
    char *data = getdata(AX);
    return (float)((*(data+1) << 8) | *data) / 32768 * 16 * g;
}

float JY901::getYaxisAcceleration()
{
    char *data = getdata(AY);
    return (float)((*(data+1) << 8) | *data) / 32768 * 16 * g;
}

float JY901::getZaxisAcceleration()
{
    char *data = getdata(AZ);
    return (float)((*(data+1) << 8) | *data) / 32768 * 16 * g;
}

float JY901::getXaxisAngularVelocity()
{
    char *data = getdata(GX);
    return (float)((*(data+1) << 8 ) | *data) / 32768 * 2000;
}

float JY901::getYaxisAngularVelocity()
{
    char *data = getdata(GY);
    return (float)((*(data+1) << 8 ) | *data) / 32768 * 2000;
}

float JY901::getZaxisAngularVelocity()
{
    char *data = getdata(GZ);
    //return (float)((*(data+1) << 8 ) | *data) / 32768 * 2000;
    return s16(*data, *(data+1)) / 32768 * 2000;
}

float JY901::getXaxisMagnetic()
{
    char *data = getdata(HX);
    return (float)((*(data+1) << 8) | *data);
}

float JY901::getYaxisMagnetic()
{
    char *data = getdata(HY);
    return (float)((*(data+1) << 8) | *data);
}

float JY901::getZaxisMagnetic()
{
    char *data = getdata(HZ);
    return (float)((*(data+1) << 8) | *data);
}

float JY901::getXaxisAngle()
{
    char *data = getdata(Roll);
    return (float)((*(data+1) << 8) | *data) / 32768 * 180;
}

float JY901::getYaxisAngle()
{
    char *data = getdata(Pitch);
    return (float)((*(data+1) << 8) | *data) / 32768 * 180;
}

float JY901::getZaxisAngle()
{
    char *data = getdata(Yaw);
    return (float)((*(data+1) << 8) | *data) / 32768 * 180;
}

float JY901::getTemperature()
{
    char *data = getdata(TEMP);
    return (float)((*(data+1) << 8) | *data) / 100;
}

float JY901::getD0Status()
{
    char *data = getdata(D0Status);
    return (float)((*(data+1) << 8) | *data) / 4095;
}

float JY901::getD1Status()
{
    char *data = getdata(D1Status);
    return (float)((*(data+1) << 8) | *data) / 4095;
}

float JY901::getD2Status()
{
    char *data = getdata(D2Status);
    return (float)((*(data+1) << 8) | *data) / 4095;
}

float JY901::getD3Status()
{
    char *data = getdata(D3Status);
    return (float)((*(data+1) << 8) | *data) / 4095;
}

float JY901::getPressure() //not use
{
    char *dataL = getdata(PressureL);
    char *dataH = getdata(PressureH);
    return (float)((*(dataH+1) << 24) | (*dataH << 16) | (*(dataL+1) << 8) | *dataL);
}

float JY901::getHeight()   //not use
{
    char *dataL = getdata(HeightL);
    char *dataH = getdata(HeightH);
    return (float)( ( *(dataH+1) << 24) | (*dataH << 16) | (*(dataL+1) << 8) | *dataL );
}

float JY901::getLongitude()    //not use
{
    char *dataL = getdata(LonL);
    char *dataH = getdata(LonH);
    return (float)( ( *(dataH+1) << 24) | (*dataH << 16) | (*(dataL+1) << 8) | *dataL );
}

float JY901::getLatitude() //not use
{
    char *dataL = getdata(LatL);
    char *dataH = getdata(LatH);
    return (float)( ( *(dataH+1) << 24) | (*dataH << 16) | (*(dataL+1) << 8) | *dataL );
}

float JY901::getGPSHeight()
{
    char *data = getdata(GPSHeight);
    return (float)((*(data+1) << 8) | *data);
}
float JY901::getGPSYaw()
{
    char *data = getdata(GPSYaw);
    return (float)((*(data+1) << 8) | *data);
}
float JY901::getGPSspeed()
{   
    char *dataL = getdata(GPSVL);
    char *dataH = getdata(GPSVH);
    return (float)( ( *(dataH+1) << 24) | (*dataH << 16) | (*(dataL+1) << 8) | *dataL );
}

char *JY901::getdata(char registar)
{
    char data[2] = {};
    _i2c->start();
    _i2c->write(IICADDR);
    _i2c->write(registar);
    _i2c->read(IICADDR, data, 2);
    _i2c->stop();
    return data;
}

float JY901::s16(int dataL, int dataH)
{
    int value = (dataH << 8) | dataL;
    return -(value & 0b1000000000000000) | (value & 0b0111111111111111);
}