#include "B3MServo.h"

//https://kondo-robot.com/faq/b3m_softwaremanual1200

/*sample program*********************************************

#include "mbed.h"
#include "B3MServo.h"

int main()
{
    B3MServo myServo(p13, p14, p12);
    myServo.onTorque(0);
    while(1)
    {
        myServo.controlAngle(0, 90);
        wait_ms(2500);
        myServo.controlAngle(0, -90);
        wait_ms(2500);
    }
}

************************************************************/

B3MServo::B3MServo(PinName tx, PinName rx, PinName enable) : BufferedSerial(tx, rx), _enable(enable)
{
    BufferedSerial::baud(115200);
    for(int i = 0; i < 0xFF; i++)
    control_mode[i] = 0xFF;
    //Serial::baud(115200);
}

void B3MServo::sendPacket(char command, char id, char addr, int data, char size, char option, char count)
{
    char packet[0x09] = {};
    
    packet[0] = size+7;
    packet[1] = command;
    packet[2] = option;
    packet[3] = id;
    for(int i = 0; i < size; i++)
        packet[4+i] = char( ( data >> (i*8) ) & 0xFF );
    packet[size+4] = addr;
    packet[size+5] = count;
    packet[size+6] = 0;
    for(int i = 0; i < packet[0]-1; i++)
        packet[size+6] += packet[i];
        
    _enable = 1;
    BufferedSerial::write(packet, packet[0]);
    //送信待機時間が必要、短いと送信できないが、長いと受信できない
    wait_us(750);
    /*_enable = 0;
    wait_us(750);
    char re[5] = {};
    for(int i = 0; i < 5; i++)
    {
        re[i] = getc();
    }*/
}

void B3MServo::sendPacket(char *id, char n, int *data, char size, char addr, char option)
{
    char packet[20] = {};
    
    packet[0] = 6 + (1+size) * n;
    packet[1] = WRITE;
    packet[2] = option;
    
    for(int i = 0; i < n; i++)
    {
        packet[3+(1+size)*i] = id[i];
        for(int j = 0; j < size; j++)
        {
            packet[3+(1+size)*i + 1+j] = (data[i] >> (j*8)) & 0xFF;
        }
    }
    packet[3+(1+size)*n] = addr;
    packet[4+(1+size)*n] = n;
    packet[5+(1+size)*n] = 0x00;
    for(int i = 0; i < packet[0]-1; i++)
        packet[5+(1+size)*n] += packet[i];
    _enable = 1;
    BufferedSerial::write(packet, packet[0]);
    wait_us(750);
}
void B3MServo::onTorque(char id, char movingMode, char controlMode)
{
    control_mode[id] = controlMode;
    sendPacket(WRITE, id, TorqueON, int((controlMode << 2) | movingMode));
}
void B3MServo::controlAngle(char id, float angle)
{
    if(control_mode[id] == Position)
    {
        sendPacket(WRITE, id, DesiredPosition, int(angle*100));
        wait_us(1000);
    }
    else
    {
        onTorque(id, Normal, Position);
        wait_us(600);
        controlAngle(id, angle);
    }
}
void B3MServo::controlAngle(char *id, char n, float *angle)
{
    int data[n];
    for(int i = 0; i < n; i++) data[i] = int(angle[i]*100);
    sendPacket(id, n, data, 2, DesiredPosition);
}
void B3MServo::controlTorque(char id, int mNm)
{
    if(control_mode[id] == Current)
    {
        sendPacket(WRITE, id, DesiredTorque, mNm);
        wait_us(1000);
    }
    else
    {
        onTorque(id, Normal, Current);
        wait_us(600);
        controlTorque(id, mNm);
    }
}

int B3MServo::readPacket(char id, char addr, char length)
{
    char packet[0x07] = {};
    
    packet[0] = 0x07;
    packet[1] = 0x03;
    packet[2] = 0x00;
    packet[3] = id;
    packet[4] = addr;
    packet[5] = length;
    packet[6] = 0;
    for(int i = 0; i < packet[0]-1; i++)
        packet[6] += packet[i];
    
    _enable = 1;
    BufferedSerial::write(packet, 7);
    wait_us(600);
    _enable = 0;
    wait_us(1000);
    char re[10] = {};
    for(int i = 0; i < 5+length; i++)
    {
        re[i] = getc();
    }
    char checksum = 0;
    for(int i = 0; i < 4+length; i++)
        checksum += re[i];
    if(checksum != re[4+length])
    {
        //printf("data error re%d != check%d", re[4+length], checksum);
        return;
    }
    
    int data = 0;
    for(int i = 0; i < length; i++)
    {
        data |= re[4+i] << (i*8);
    }
    return data;
}

float B3MServo::getCurrentPosition(char id)
{
    int data = readPacket(id, CurrentPosition, 2);
    wait_us(1000);
    return float(data) / 100;
}

float B3MServo::getCurrent(char id)
{
    return float(readPacket(id, CurrentAmpere, 2));
}