#ifndef B3MSERVO_H
#define B3MSERVO_H

#include "mbed.h"
#include "BufferedSerial.h"

/*【COMMAND】**************************************/
#define LOAD            0x01
#define SAVE            0x02
#define READ            0x03
#define WRITE           0x04
#define RESET           0x05
#define POSITION        0x06

/*Memory Map(just using)****************************************/
#define TorqueON        0x28
#define RunMode         0x29
#define DesiredPosition 0x2A
#define CurrentPosition 0x2C
#define DesiredVelosity 0x30
#define CurrentVelosity 0x32
#define DesiredTorque   0x3C
#define CurrentAmpere   0x48

/*TorqueOn*************************************************/
/*0-1bit(動作モード)************************/
#define Normal 0x00
#define Free 0x02
#define Hold 0x03
/*2-3bit(制御モード)************************/
#define Position    0x00
#define Speed       0x01
#define Current     0x02
#define FeedForward 0x03

class B3MServo : public BufferedSerial
{
    public:
    B3MServo(PinName tx, PinName rx, PinName enable = NC);
    void sendPacket(char command, char id, char addr, int data, char size = 2, char option = 0x03, char count = 0x01);
    void sendPacket(char *id, char n, int *data, char size, char addr, char option = 0x03);
    void onTorque(char id, char movingMode = Normal, char controlMode = Position);
    void controlAngle(char id, float angle);
    void controlAngle(char *id, char n, float *angle);
    void controlTorque(char id, int mNm);
    
    int readPacket(char id, char addr, char length);
    float getCurrentPosition(char id);
    float getCurrent(char id);
    
    private:
    DigitalOut _enable;
    char control_mode[0xFF];
};

#endif