/** @defgroup API The MODGPS API */

/** GPS module
 * @author Andy Kirkham
 * @see http://mbed.org/cookbook/MODGPS
 * @see example1.cpp
 * @see example2.cpp
 * @see API 
 *
 * @image html /media/uploads/AjK/gps_interfaces.png "Wiring up the GPS module"
 *
 * Example:
 * @code
 * #include "mbed.h"
 * #include "GPS.h"
 *
 * DigitalOut led1(LED1);
 * Serial pc(USBTX, USBRX);
 * GPS gps(NC, p10); 
 *
 * int main() {
 *     GPS_Time t;
 *
 *     // Wait for the GPS NMEA data to become valid.
 *     while (!gps.isTimeValid()) {
 *       led1 = !led1;
 *       wait(1);
 *     }
 *
 *     gps.timeNow(&t);
 *
 *     pc.printf("The time/date is %02d:%02d:%02d %02d/%02d/%04d\r\n",
 *        t.hour, t.minute, t.second, t.day, t.month, t.year);
 *
 *     // Wait until at least four satellites produce a position fix and a valid quality.
 *     while (gps.numOfSats() < 4 && gps.getGPSquality != 0) {
 *       led1 = !led1;
 *       wait(1);
 *     }
 *
 *     pc.printf("Lat = %.4f Lon = %.4f Alt = %.1fkm\r\n", 
 *         gps.latitude(), gps.longitude, gps.altitude());
 *
 *     // Make the LED go steady to indicate we have finished.
 *     led1 = 1;
 * 
 *     while(1) {}
 * }
 * @endcode
 */