#include "mbed.h"

// using a led
DigitalOut myled(LED1);

void DisconnectPLL0(){
    // good practice to disable before feeding
    __disable_irq();
    // disconnect
    LPC_SC->PLL0CON = 0x1;
    LPC_SC->PLL0FEED = 0xAA;
    LPC_SC->PLL0FEED = 0x55;
    while (LPC_SC->PLL0STAT&(1<<25));
    // power down
    LPC_SC->PLL0CON = 0x0;
    LPC_SC->PLL0FEED = 0xAA;
    LPC_SC->PLL0FEED = 0x55;
    while (LPC_SC->PLL0STAT&(1<<24));
    // This is the default flash read/write setting for IRC
    LPC_SC->FLASHCFG &= 0x0fff;
    LPC_SC->FLASHCFG |= 0x5000;
    LPC_SC->CCLKCFG = 0x0;
    //  Select the IRC as clk
    LPC_SC->CLKSRCSEL = 0x00;
    // not using XTAL anymore
    LPC_SC->SCS = 0x00;
}

// IAP address
#define IAP_LOCATION 0x1FFF1FF1
// variable for command and result
unsigned int command[5];
unsigned int result[5];
// function pointer with 2 array parameters
typedef void (*IAP)(unsigned int[5],unsigned int [5]);
// declaration of the fptr.
IAP iap_entry = (IAP)IAP_LOCATION;

int main(){
    
   //! change clk to 4MHz - see below
   DisconnectPLL0();
   //! stop all ISRs
   __disable_irq();
   //!make IAP call
   command[0] = 57;
   iap_entry(command, result);
   
   //! This should never get executed
   while(1) {
       myled = 1;
       wait(0.2);
       myled = 0;
       wait(0.2);
   }
}
