#include "mbed.h"
#include "EthernetInterface.h"

int main() {

    uint8_t mac_addr[6] = {0x00, 0x08, 0xdc, 0x45, 0x56, 0x67};
    
    Serial pc(USBTX, USBRX);
    
    int err;

    pc.baud(115200);
    wait(1);
    pc.printf("\r\nSPI to Ethernet Slave\r\n");
  
    SPI spi(PA_7,PA_6,PA_5); // mosi, miso, sclk
    spi.format(32, 0);
    spi.frequency(100000);
    wait(3);
  
    pc.printf("Wait a second...\r\n");
    
    pc.printf("Network Setting DHCP\r\n");
    EthernetInterface eth(&spi, PB_6, NC); // mosi, miso, sclk, cs, reset
    err = eth.init(mac_addr);
    if (err) {
        pc.printf("Error in eth init\n\r");
        exit(0);
    }
    
    pc.printf("Initialized, MY_MAC: %s\r\n", eth.getMACAddress());
   
    err = eth.connect();
    if (err) {
        pc.printf("Error in eth connect\r\n");
        exit(0);        
    }
    pc.printf
            (
                "Connected with IP: %s, NETMASK: %s, GATEWAY: %s\n\r",
                eth.getIPAddress(),
                eth.getNetworkMask(),
                eth.getGateway()
            );
    
    while(1) 
    { 
        pc.printf("Check Ethernet Link\r\n");
        if(eth.link() == true)
        {
            pc.printf("Link up\r\n");
            break;
        }
        wait(1);
    }

    const char* Target_addr = "192.168.40.60";
    const int Target_port = 8080;

    TCPSocketConnection socket;
    err = socket.connect(Target_addr, Target_port);
    if (err) {
        pc.printf("Unable to connect to (%s) on port (%d). Error: %d\r\n", Target_addr, Target_port, err);
        exit(0);
    }
    pc.printf("Connected to %s on port%d\r\n", Target_addr, Target_port);
    
    char* reqMsg = "GET /api/user HTTP/1.1\r\nHost: kama.blackhawk-lab.itron.com\r\n\r\n";
    err = socket.send_all(reqMsg, strlen(reqMsg));
    if (err == -1) {
        pc.printf("send_all error: %d\r\n", err);
        exit(0);
    }

    char resp[10240];
    int count = socket.receive_all(resp, sizeof(resp));
    if (err == -1) {
        pc.printf("receive_all error: %d\r\n", err);
        exit(0);
    }
    pc.printf("%.*s\r\n", count, resp);

    exit(0);
}