#include "mbed.h"

#include "pb_decode.h"
#include "sample.pb.h"

int main()
{
    printf("\nProtoBufTest\n");
    
    uint8_t buffer[2] = { 0x10, 0x05 };
    size_t message_length = 2;
    
    protocol_Sample message = protocol_Sample_init_zero;
    pb_istream_t stream = pb_istream_from_buffer(buffer, message_length);
    bool status = pb_decode(&stream, protocol_Sample_fields, &message);
    if (!status) {
        printf("Decoding failed: %s\n", PB_GET_ERROR(&stream));
        exit(1);
    }
    printf("Alarm: %d\n", message.alarm);
    
    exit(0);
}