#pragma once

#include "scheduler.h"

namespace JobScheduler {

    class RunOnceSchedule: public ISchedule {
        public:
            RunOnceSchedule(time_t time): _time(time) {}
            
            time_t AtTime() {
                return _time;
            }
            
            virtual ~RunOnceSchedule() {}
            
            virtual time_t NextRunTime(time_t from) {
                time_t current = _time;
                _time = 0;
                return current;
            }
            
            virtual int ScheduleType() {
                return 1;  // matches protocol_ScheduleType_RunOnce in job.pb.h
            }
                    
        private:
            time_t _time;
    };
    
    class RunPeriodicSchedule: public ISchedule {
        public:
            RunPeriodicSchedule(time_t period, int limit = 0)
            : _period(period), _limit(limit), _counter(0) {};
            
            virtual ~RunPeriodicSchedule() {}
            
            virtual time_t NextRunTime(time_t from) {
                if (_limit > 0 && _counter == _limit) {
                    // no next run
                    return 0;
                }
                _counter++;
                time_t next = from + _period;
                return next;
            }
            
            virtual int ScheduleType() {
                return 2;  // matches protocol_ScheduleType_Periodic in job.pb.h
            }
        
        private:
            time_t _period;
            /** limit limits number of times to execute NextRunTime.
            If set to zero, then it is unlimitted.
            */
            int _limit;
            int _counter;
    };

} // end of namespace