#include "jobService.h"

// silence scheduler tracing, must be before mbed_trace.h
#define MBED_TRACE_MAX_LEVEL 0
#include "mbed-trace/mbed_trace.h"
#define TRACE_GROUP  "scjs"

namespace JobScheduler {

bool JobType::AscendingExcl(JobType *j2) 
{
    return this->_jobTypeID > j2->_jobTypeID;
}

bool JobType::IsEqual(JobType *j2)
{
    bool rv = this->_jobTypeID == j2->_jobTypeID;
    tr_debug("IsEqual %d==%d: %d", this->_jobTypeID, j2->_jobTypeID, rv);
    return rv;
}

bool jtAscending(JobType *j1, JobType *j2)
{
    return j1->AscendingExcl(j2);
}

bool jtIsEqual(JobType *j1, JobType *j2)
{
    return j1->IsEqual(j2);
}

Error JobService::Register(int jobTypeID, jobFunc *job, void *context)
{
    JobType *jt = new JobType(jobTypeID, job, context);
    node<JobType> *tmp = _jobs.insertOrdered(jt, jtAscending);
    if (NULL == tmp) {
        tr_error("Failed to register job type id %d", jobTypeID);
        return Error(1);
    }
    return NoError; 
}

JobType* JobService::GetJob(int jobTypeID)
{
    tr_debug("find with job type id %d", jobTypeID);
    JobType search = JobType(jobTypeID, NULL, NULL);
    node<JobType> *found = _jobs.pop(&search, jtIsEqual);
    if (found == NULL) {
        tr_debug("jobTypeID %d is NOT found", jobTypeID);
        return NULL;
    }
    return found->data;
}

} // end of namespace