#pragma once

#include "LinkedList.h"

namespace JobScheduler {
    
    typedef void (jobFunc)(void *context);
    
    // Error type uses zero to indicate no Error.
    // Any other value is an error with error code.
    typedef int Error;
    
    const Error NoError = Error(0);

    /**
    JobType connects job type ID to job function.
    */
    class JobType {
        public:
            JobType(int jobTypeID, jobFunc *job, void *context)
            : _jobTypeID(jobTypeID), _job(job), _context(context) {}

            void RunJob() {
                _job(_context);
            }

            bool AscendingExcl(JobType *d2);
            bool IsEqual(JobType *d2);

        private:
            int _jobTypeID;
            jobFunc *_job;
            void *_context;
    };
    
    /**
    JobService connects job type ID to job function.
    */
    class JobService {
        public:
        
            JobService() {}
            
            /**
            Register associates jobTypeID with job and stores association.
            @returns Error if failed to register.
            */
            Error Register(int jobTypeID, jobFunc *job, void *context);
            
            /**
            GetJob returns job function based on jobTypeID.
            @returns NULL if job is not found.
            */
            JobType* GetJob(int jobTypeID);
                    
        private:
            /* 
            _jobs stores job registrations.
            Current implementation uses LinkedList, because it assumes that
            number of jobs is no more than 10 or 20.
            */
            LinkedList<JobType> _jobs;
    };
    
} // end of namespace