#pragma once

#include "mbed.h"
#include "lceProxy.h"

/** JobTestUpload uploads a hardcoded message to a hardcoded LCE endpoint. */
class JobTestUpload {
    public:
    
    /** RunAdapter is scheduler callback function. 
    @param thisPointer provides job context, which is this class's instance.
    */
    static void RunAdapter(void *thisPointer) {
        JobTestUpload *self = static_cast<JobTestUpload*>(thisPointer);
        self->Run();
    }
    
    /** JobTestUpload constructor arguments take services it depends on. */
    JobTestUpload(LceProxy& lce): _lce(lce) {}
    
    void Run();
    
    private:
    
    LceProxy& _lce;    
};