#include "jobFakeADC.h"

#include "mbed-trace/mbed_trace.h"
#define TRACE_GROUP  "jtp"
#include "us_ticker_api.h"

__packed struct AdcCh {
    uint32_t Raw;   // 4 bytes
    uint32_t V;     // 4 bytes   // TODO: it is supposed to be float32
};

__packed struct AdcMsg {
    uint64_t Created;       // 8 bytes
    uint8_t Mask;           // 1 byte
    struct AdcCh Chs[8];    // 64 = 8 * (4+4)
};  // 8+1+64=73

uint32_t swap_uint32(uint32_t num)
{
    /*
    source: https://stackoverflow.com/questions/2182002/convert-big-endian-to-little-endian-in-c-without-using-provided-func
    */
    return ((num>>24)&0xff) | // move byte 3 to byte 0
           ((num<<8)&0xff0000) | // move byte 1 to byte 2
           ((num>>8)&0xff00) | // move byte 2 to byte 1
           ((num<<24)&0xff000000);
};

uint64_t swap_uint64( uint64_t uvalue )
{
    /* 
    source: https://stackoverflow.com/questions/2182002/convert-big-endian-to-little-endian-in-c-without-using-provided-func
    https://social.msdn.microsoft.com/Forums/vstudio/en-US/144b3047-bcbd-48d6-a28a-6fbda82e151e/convert-big-endian-to-little-endian?forum=csharpgeneral
    */

    return ( (0x00000000000000FF) & (uvalue >> 56)
        | (0x000000000000FF00) & (uvalue >> 40)
        | (0x0000000000FF0000) & (uvalue >> 24)
        | (0x00000000FF000000) & (uvalue >> 8)
        | (0x000000FF00000000) & (uvalue << 8)
        | (0x0000FF0000000000) & (uvalue << 24)
        | (0x00FF000000000000) & (uvalue << 40)
        | (0xFF00000000000000) & (uvalue << 56));
}

void JobFakeADC::Run() {
    tr_info("Job Fake ADC");
    time_t now = time(NULL);
    //tr_debug("ADC created time is: %s\n", ctime(&now));
    struct AdcMsg msg;
    // convert seconds to nanoseconds
    msg.Created = now * 1e9;
    tr_debug("Current time: %x sec, %llx nanosecs", now, msg.Created);
    // swapt for byte order
    msg.Created = swap_uint64(msg.Created); // swap_uint64(msg.Created);
    msg.Mask = 0x80; // 0x80 bits: 1000 0000
    for (int i = 0; i < 8; i++) {
        msg.Chs[i].Raw = 0;
        msg.Chs[i].V = 0;
    }
    msg.Chs[0].Raw = swap_uint32(_next++);
    msg.Chs[0].V = msg.Chs[0].Raw;
    // /test can be used to send to test endpoint that responds with
    // a short hardcoded string
    // /uw/adc - to send adc version 1
    _lce.SendV1("/uw/adc", (uint8_t*)&msg, sizeof(msg), false, now);
}
