#pragma once

#include "mbed.h"
#include "config.h"

/**
LceProxy is an application service allowing to send data to LCE headend using
LCE specific protocols.

LCE is developed by Itron "Advanced Research and Development" team.
*/
class LceProxy {
    public:
    
    LceProxy(NetworkInterface& ni, Config conf): _ni(ni), _conf(conf) {}
    
    /**
    Sends data using Version 1 protocol.
    */
    void SendV1(const char* path, uint8_t *data, size_t dataLen, bool isAlarm, time_t taken);
    
    private:
    
    NetworkInterface& _ni;
    Config _conf;
};
