#pragma once

#include "mbed.h"
#include "lceProxy.h"
#include "scheduler.h"
#include "config.h"

// JobSchedulesUpload reads current jobs schedule and uploads it to LCE
// using Job protocol buffers structures.
/** JobSchedulesUpload uploads shceduler state to LCE HE. */
class JobSchedulesUpload {
    public:
    
    /** RunAdapter is scheduler callback function. 
    @param thisPointer provides job context, which is this class's instance.
    */
    static void RunAdapter(void *thisPointer) {
        JobSchedulesUpload *self = static_cast<JobSchedulesUpload*>(thisPointer);
        self->Run();
    }

    /** JobSchedulesUpload constructor arguments are its service dependencies. */
    JobSchedulesUpload(Config& conf, LceProxy& lce, JobScheduler::Scheduler& scheduler): 
        _conf(conf), _lce(lce), _scheduler(scheduler) {}
    
    void Run();
    
    private:
    
    Config _conf;
    LceProxy& _lce;
    JobScheduler::Scheduler& _scheduler;
};