#pragma once

#include "mbed.h"
#include "lceProxy.h"

/** JobFakeADC is a job that simulates ADC data uploads to HE. */
class JobFakeADC {
    public:
    
    /** RunAdapter is scheduler callback function. 
    @param thisPointer provides job context, which is this class's instance.
    */
    static void RunAdapter(void *thisPointer) {
        JobFakeADC *self = static_cast<JobFakeADC*>(thisPointer);
        self->Run();
    }

    /** JobFakeADC constructor takes services as dependencies. */
    JobFakeADC(LceProxy& lce): _lce(lce), _next(1) {}
    
    void Run();
    
    private:
    
    LceProxy& _lce;
    int _next;
    
};