#pragma once

/**
@brief Config is an application service collecting device specific configuration
parameters.

Configuration allows for parameters change, but it is not epxected to happen
frequently.
*/
class Config {
    public:
    
    Config(char* sn): _sn(sn) {}
    
    /** @brief SerialNumber returns serial number of the device.
    
    SN is used to uniquely identify the device when it sends data to HE.
    */
    const char* SerialNumber() {
        return _sn;
    }
            
    private:
    
    char* _sn;
};