#include "lceProxy.h"

#include "mbed.h"
#include "sn_coap_protocol.h"
#include "sn_coap_header.h"

#include "mbed-trace/mbed_trace.h"
#define TRACE_GROUP  "lce"

// CoAP HAL
void* coap_malloc(uint16_t size) {
    return malloc(size);
}

void coap_free(void* addr) {
    free(addr);
}

// tx_cb and rx_cb are not used in this program
uint8_t coap_tx_cb(uint8_t *a, uint16_t b, sn_nsdl_addr_s *c, void *d) {
    tr_warn("coap tx cb");
    return 0;
}

int8_t coap_rx_cb(sn_coap_hdr_s *a, sn_nsdl_addr_s *b, void *c) {
    tr_warn("coap rx cb");
    return 0;
}

Thread receiver;      // Thread to receive messages over CoAP
UDPSocket socket;
struct coap_s* coapHandle;
coap_version_e coapVersion = COAP_VERSION_1;


// Main function for the recvfrom thread
void receive() {
    SocketAddress addr;
    uint8_t* recv_buffer = (uint8_t*)malloc(1280); // Suggested is to keep packet size under 1280 bytes

    nsapi_size_or_error_t ret;

    while ((ret = socket.recvfrom(&addr, recv_buffer, 1280)) >= 0) {
        // to see where the message came from, inspect addr.get_addr() and addr.get_port()

        tr_debug("Received a message of length '%d'", ret);

        sn_coap_hdr_s* parsed = sn_coap_parser(coapHandle, ret, recv_buffer, &coapVersion);

        tr_debug("\tmsg_id:           %d", parsed->msg_id);
        tr_debug("\tmsg_code:         %d", parsed->msg_code);
        tr_debug("\tcontent_format:   %d", parsed->content_format);
        tr_debug("\tpayload_len:      %d", parsed->payload_len);
        tr_debug("\tpayload:          ");
        tr_array(parsed->payload_ptr, parsed->payload_len);
        tr_debug("\toptions_list_ptr: %p", parsed->options_list_ptr);
    }

    free(recv_buffer);

    tr_error("UDPSocket::recvfrom failed, error code %d. Shutting down receive thread.", ret);
}

void LceProxy::SendV1(const char* path, uint8_t *data, size_t dataLen, bool isAlarm, time_t taken)
{
    
    // Open a socket on the network interface
    socket.open(&_ni);

    // Initialize the CoAP protocol handle, pointing to local implementations on malloc/free/tx/rx functions
    coapHandle = sn_coap_protocol_init(&coap_malloc, &coap_free, &coap_tx_cb, &coap_rx_cb);

    // UDPSocket::recvfrom is blocking, so run it in a separate RTOS thread
    //receiver.start(&receive);

    // URIPath option id is 11.
    // URIQuery option id is 15.  Option delta is 15-11=4.

    sn_coap_options_list_s options;
    memset(&options, 0, sizeof(sn_coap_options_list_s));
    options.uri_port = -1; // -1 if not used
    options.observe = -1;  // -1 if not used
    options.block1 = -1;   // -1 if not used
    options.block2 = -1;   // -1 if not used
    options.max_age = 60;  // restore default 60
    options.accept = COAP_CT_NONE; // COAP_CT_NONE is not used
    char* query = "S=Nucleo1&TH=14d14764c9a7a2fb";
    options.uri_query_ptr = (uint8_t*)query;
    options.uri_query_len = strlen(query);
    
    
    // * HEX build is not a way to go! * the following is a bad way
    // HEX: 53 4e 3d 4e 75 63 6c 65 6f 31  is "SN=Nucleo1"
    // uint8_t query[] = { 0x3, 0xA, 0x53, 0x4e, 0x3d, 0x4e, 0x75, 0x63, 0x6c, 0x65, 0x6f, 0x31 };
    // options.uri_query_ptr = query;
    // options.uri_query_len = 12; // strlen(query)

    // See ns_coap_header.h
    sn_coap_hdr_s *coap_res_ptr = (sn_coap_hdr_s*)calloc(sizeof(sn_coap_hdr_s), 1);
    coap_res_ptr->uri_path_ptr = (uint8_t*)path;       // Path
    coap_res_ptr->uri_path_len = strlen(path);
    coap_res_ptr->msg_code = COAP_MSG_CODE_REQUEST_GET;         // CoAP method
    coap_res_ptr->content_format = COAP_CT_TEXT_PLAIN;          // CoAP content type
    coap_res_ptr->payload_len = dataLen;                              // Body length
    coap_res_ptr->payload_ptr = data;                              // Body pointer
    coap_res_ptr->options_list_ptr = &options;                         // Optional: options list
    // Message ID is used to track request->response patterns, because we're using UDP (so everything is unconfirmed).
    // See the receive code to verify that we get the same message ID back
    coap_res_ptr->msg_id = 7;
    
    // print payload content as hex string
    {
        int hexOutSize = 3*dataLen+1;
        char* hexOut = new char[hexOutSize];
        hexOut[0] = 0;
        for (int i = 0; i < dataLen; i++) {
            snprintf(hexOut, hexOutSize, "%s %02x", hexOut, data[i]);
        }
        tr_debug("CoAP Payload: %s", hexOut);
        delete hexOut;
    }
    
    // Calculate the CoAP message size, allocate the memory and build the message
    uint16_t message_len = sn_coap_builder_calc_needed_packet_data_size(coap_res_ptr);
    tr_debug("Calculated message length: %d bytes", message_len);

    uint8_t* message_ptr = (uint8_t*)malloc(message_len);
    sn_coap_builder(message_ptr, coap_res_ptr);

    // Uncomment to see the raw buffer that will be sent...
    // tr_debug("Message is: ");
    // for (size_t ix = 0; ix < message_len; ix++) {
    //     tr_debug("%02x ", message_ptr[ix]);
    // }
    // tr_debug("");

    const char host[] = "kama.blackhawk-lab.itron.com";
    int scount = 0;
    scount = socket.sendto(host, 5683, message_ptr, message_len);
    //Thread::wait(3);
    tr_debug("Sent %d bytes to coap://%s:5683", scount, host);

    socket.close();   

    free(coap_res_ptr);
    free(message_ptr); 
    
}