#include "netstack.h"

#include "mbed-trace/mbed_trace.h"
#define TRACE_GROUP  "net"

#include "mbed.h"

#include "nsapi_dns.h"  // standard DNS

#define ETH_W5500 1

#if defined(ETH_W5500)

#include "W5500Interface.h"  // W5500 driver for mbed
#include "DHCPClient.h"    // DHCPClient from W5500 driver
DHCPClient dhcp;

#if defined(TARGET_NUCLEO_L476RG)
SPI spi(PA_7,PA_6,PA_5); // mosi, miso, sclk
W5500Interface eth(&spi, PB_6, NC); // mosi, miso, sclk, cs, reset
#endif  // of TARGET_NUCLEO_L476RG

#endif  // of ETH_W5500

/* \brief print_MAC - print_MAC  - helper function to print out MAC address
 * in: network_interface - pointer to network i/f
 *     bool log-messages   print out logs or not
 * MAC address is print, if it can be acquired & log_messages is true.
 *
 */
void print_MAC(NetworkInterface* network_interface) {
    const char *mac_addr = network_interface->get_mac_address();
    if (mac_addr == NULL) {
        tr_debug("No MAC address");
        return;
    }
    tr_debug("MAC: %s", mac_addr);
}

NetworkInterface* initNetworkStack(uint8_t mac_addr[6]) {
    NetworkInterface* network_interface = 0;
    int connect_success = -1;
    // This should be removed once mbedOS supports proper dual-stack
#if (MBED_CONF_LWIP_IPV6_ENABLED==true)
    tr_error("IPv6 mode");
#else
    tr_debug("IPv4 mode");
#endif
    
    char ip[24], gateway[24], netmask[24], dnsaddr[24];
#if defined(ETH_W5500)
    spi.format(32, 0);
    spi.frequency(100000);
    wait(1);

    tr_debug("Using W5500");
    eth.init(mac_addr);
    int timeout_ms = 15*1000;
    int err = dhcp.setup(&eth, mac_addr, timeout_ms);
    if (err == (-1)) {
        tr_error("DHCP Timeout.");
        return NULL;
    }
    tr_debug("Connected; IP: %d.%d.%d.%d", dhcp.yiaddr[0], dhcp.yiaddr[1], dhcp.yiaddr[2], dhcp.yiaddr[3]);
    if (0==dhcp.yiaddr[0] && 0==dhcp.yiaddr[1] && 0==dhcp.yiaddr[2] && 0==dhcp.yiaddr[3]) {
        tr_error("IP is 0.0.0.0 after DHCP");
        return NULL;
    }
    sprintf(ip,      "%d.%d.%d.%d", dhcp.yiaddr[0],  dhcp.yiaddr[1],  dhcp.yiaddr[2],  dhcp.yiaddr[3]);
    sprintf(gateway, "%d.%d.%d.%d", dhcp.gateway[0], dhcp.gateway[1], dhcp.gateway[2], dhcp.gateway[3]);
    sprintf(netmask, "%d.%d.%d.%d", dhcp.netmask[0], dhcp.netmask[1], dhcp.netmask[2], dhcp.netmask[3]);
    sprintf(dnsaddr, "%d.%d.%d.%d", dhcp.dnsaddr[0], dhcp.dnsaddr[1], dhcp.dnsaddr[2], dhcp.dnsaddr[3]);
    eth.init(ip, netmask, gateway);
#endif
   
    const SocketAddress dns_sa = SocketAddress((const void *)&dhcp.dnsaddr[0], NSAPI_IPv4, 53);
    nsapi_error_t nsErr = nsapi_dns_add_server(dns_sa);
    if (nsErr) {
        tr_error("error adding DNS entry: %d", nsErr);
        return NULL;
    }
    tr_debug("DNS IP: %s", dns_sa.get_ip_address());
    
//    SocketAddress coap_sa;
//    nsErr = nsapi_dns_query(&eth, "coap.me", &coap_sa, NSAPI_IPv4);
//    if (nsErr) {
//        tr_debug("[EasyConnect] error resolving coap.me: %d\n", nsErr);
//    }

    network_interface = &eth;
    connect_success = eth.connect();

    print_MAC(network_interface);
    if(connect_success != 0) {
        tr_error("Failed to connect: %d!", connect_success);
        return NULL;
    }
    tr_debug("Connected to Network successfully");
    
    const char *ip_addr  = network_interface->get_ip_address();
    if (ip_addr == NULL) {
        tr_error("There is NO IP address");
        return NULL;
    }
    tr_debug("IP: %s", ip_addr);
    
    return network_interface;
}
