#pragma once

// Include main application documentation.
/** 

@file main.cpp 

@brief Contains application entry point and oulines core application design.

@section s_design_overview Design Overview

The application is designed around the concept of serial execution of high level tasks called jobs.  The 'scheduler' library is responsible for maintaining job schedules and ensuring that only one job is executing at any given time.  See Scheduler library for details related to order of execution and scheduling.

Each job is defined as a function that needs to be executed.  Currently the job function does not take any arguments.  It is planned that job may take a single argument of Scheduler::Appointment type.  Appointment provides scheduler oriented details about the job and job instance specific configuration parameters.

Each job has its own unique context that's defined by its dependency on application specific services.  Application service is a cohesively defined application feature.  Examples of application services:

@li LCE is a lightweight collection engine proxy.  LCE provides interface for sending CoAP data to headend (HE).

@li Configuration service collects device specific configuration such as Serial Number and other parameters that can be changed through commands while device is running.

@li Network stack service is defined by mbed OS itself through NetworkInterface class.  NetworkInterface is a good example of changing application functionality through change of interface implementation.  For example, it can use W5500 driver and it can be use a cell modem driver.

@li Scheduler is a service object from design level point of view.  Scheduler can be passed as a context dependency to jobs that need to manipulate schedules.

In the modern application design internal application service is usually defined as an interface.  That interface then has production level implementation and may have test level mock implementations.  While Borsch is not specifically designed with this purpose in mind, it does not preclude the model.

Service objects are expected to be not NULL.  Failure to create a service object results in application termination as it results in cascading failure effect.

If job is implemented as a C++ class, then its service references should be instance variables.  C++ 'reference' is recommended instead of pointer, because services are always expected to be not NULL.  If a particular service can be NULL, then recommendation does not apply.
If job is implemented as a C module, then a separate initialize function is expected to set module level dependency variables.

@subsection do_application_lifetime Application Lifetime

Once service objects are created, job scheduler is started on the main application thread.  Main thread is then blocked by waiting for scheduler to quit.  Unless there is a job that explicitly requests scheduler termination, the main thread will never unblock. 

If scheduler stops, then main thread proceeds to the final stage of the application.  At this stage it is guaranteed that no job will be running and no new job can be started, because scheduler has been stopped.  Thus, environment is fully under the main() function control and drastic changes can be applied such as firmware upgrades.

@subsection do_job_lifetime Job Lifetime

Job is a simple C function that executes as C module function or that acts as an adapter to C++ method.

The simplest job is a function that does nothing.  A slightly more complicated job can just print "Hello, world!".

Job scheduler calls the function when it is time to execute it.  Job scheduler guarantees that no other job can be running at the same time.  Job scheduler takes care of make sure that job function is called again according to assigned schedule.

Job scheduler does not guarantee that job will be started at exactly the requested time.  If you want to make sure that job is started at the right time make sure you don't schedule more than one job for the same time or schedule 2 jobs too close to each other.  Thus, the responsibility of ensuring that job starts at the right time sits at higher level with person how creates the overall schedule for all jobs.

The next job run time is calculated by the scheduler after job function returns.  

In the future, when job takes Scheduler::Appointment data structure as an argument, the job will be able to dynamically modify its schedule.  For example, the following scenario will be possible.  Job is started with run once schedule.  Run once schedule ensures that job runs only once.  Prior to returning job can set new RunOnce schedule and thus have a variable business dependent timing with little added complexity.

@subsection do_parallel_to_jobs Running of Other Parallel Threads

The job is just another C function and thus there is nothing to stop function from creating its own thread after execution ends.  This is not denied, but a high level impact needs to be considered.

For example, a receiving thread can be started for the life time of the socket.

One consequence to consider is that creation of long running threads that go beyond job lifetime will make it more difficult to manage power consumption.  The recommended solution is to schedule another job through application scheduler from the job function itself. This way a single task at a time concept is not impacted and there is no concurrency complication.

@section s_tracing Tracing

Application relies on mbed OS tracing functionality to make it easier to debug modules.

References:

@li http://www.emcu.eu/wp-content/uploads/2017/06/07-HandsOn-Part-3-Debugging-And-Tracing.pdf



*/ 