// difference of right x - left x values < 21, then enter turn speed (possibly slow down by reversing)
// with that, we need to be able to read both cameras


#include "mbed.h"
#include "TFC.h"
#include <iostream>
#include <cstdlib>
#include <cstring>
#define print PC.printf
#define lowLoop 26
#define highLoop 107
#define thresholdAllowance0 1
#define thresholdAllowance1 1
#define driveFlag TFC_GetDIP_Switch() & 0x01
#define printFlag TFC_GetDIP_Switch() & 0x02
#define steerFlag TFC_GetDIP_Switch() & 0x04
#define turnThresh .5
// new defines
#define steerDifAllowance .15
#define steerCounterAllowance 9
// 0 is right, 1 is left for camera dominance
#define domCamFlag TFC_GetDIP_Switch() & 0x08 
#define turnSpeed .4
#define cruiseSpeed .45
#define fastSpeed .5
//Cycles of prayMax
#define prayMax 50
//Allowed difference between previous xCount
#define xCountAllowance 6

DigitalOut myled(LED1); // 1 = blue, 2 = green, 3 = red

void turn(float val, char mode);
void checkCamera();
void checkCameraTest();
void twoLineCamera();
void setColorCharacter(int index);
void testCameraTracking();
void turnTest2();
bool checkRightCamera();
bool checkLeftCamera();
void hailMary();
void setDriveSpeed();

Serial pc(USBTX, USBRX);

//int rightside = 0; ???
//int leftside = 0;

bool leftLineFound = false;
bool rightLineFound = false;
char domCam = 'U';
//Right Camera
int xCountR = 0;
int firstXR = 0;
int whiteFlagR = 0;
int blackFlagR = 0;
// for new track
int whiteCountR, whiteFlag2R, secondXR = 0;

//Left Camera
int xCountL = 0;
int firstXL = 0;
int whiteFlagL = 0;
int blackFlagL = 0;

// for new track
int whiteCountL, whiteFlag2L, secondXL = 0;
float AverageLightThresholdA1 = 0.0;
float AverageLightThresholdA2 = 0.0;
float AverageLightThresholdA3 = 0.0;
float AverageLightThresholdA4 = 0.0;
float AverageLightThresholdA5 = 0.0;
float AverageLightThresholdA = 0.0;
float AverageLightThresholdB1 = 0.0;
float AverageLightThresholdB2 = 0.0;
float AverageLightThresholdB3 = 0.0;
float AverageLightThresholdB4 = 0.0;
float AverageLightThresholdB5 = 0.0;
float AverageLightThresholdB = 0.0;


float steerDif = 0.0;
float driveSpeed = 0.0;
float lowTurnThresh = 0.0;
float highTurnThresh = 0.0;

float lastXCountR = -10;
float lastXCountL = -10;


char line0[81];
char line1[81];
float oldSteerDif = 0;
int steerDifCounter = 0;

//bool seeRight = false; ???
//bool seeLeft = false;

int prayCounter = 0;

int main()
{
    TFC_LineScanImageReady = 0;

    TFC_Init(); // initializes TFC API
    lowTurnThresh = turnThresh + ((TFC_ReadPot(0)+1)/2)*(1-turnThresh);
    highTurnThresh = ((TFC_ReadPot(1)))*turnThresh;
    if(printFlag){
    pc.printf("\n\n\n\n\n\n\r");
    }

    TFC_HBRIDGE_ENABLE;


//    driveTest();
    while(1)
    {
        checkCamera();
    }


    //showLight(); // LED indicator (to let us know the code is running)
//    testMotor();
}


void turnTest2()
{

    for (int i =-35; i< 35; i++) {
        float value = i* .1;
        TFC_SetServo(0,value);
        wait(.02);


    }
}

//Gets Camera Data
void checkCamera()
{
    if (TFC_LineScanImageReady != 0) {
//        pc.printf("here 1\n");


        AverageLightThresholdA5 = AverageLightThresholdA4;
        AverageLightThresholdA4 = AverageLightThresholdA3;
        AverageLightThresholdA3 = AverageLightThresholdA2;
        AverageLightThresholdA2 = AverageLightThresholdA1;
        AverageLightThresholdA1 = 0.0;
        AverageLightThresholdB5 = AverageLightThresholdB4;
        AverageLightThresholdB4 = AverageLightThresholdB3;
        AverageLightThresholdB3 = AverageLightThresholdB2;
        AverageLightThresholdB2 = AverageLightThresholdB1;
        AverageLightThresholdB1 = 0.0;


        // Gets the input of the current lines for both cameras
        for (int i= lowLoop; i< highLoop; i++) {
            AverageLightThresholdA1 = TFC_LineScanImage0[i] + AverageLightThresholdA1;
            AverageLightThresholdB1 = TFC_LineScanImage1[i] + AverageLightThresholdB1;
            setColorCharacter(i);
        }
        if(printFlag) {
            pc.printf("|");
            for( int i=0; i <(highLoop-lowLoop); i++) {
                pc.printf("%c", line1[i]);
            }
            pc.printf("|");
            for( int i=0; i <(highLoop-lowLoop); i++) {
                pc.printf("%c", line0[i]);
            }
            pc.printf("|");
            
            pc.printf(" %i,   %i", firstXL, firstXR); 
        }

        //Keeps track of the average lighting to maintain a moving average threshold
        AverageLightThresholdA1 = AverageLightThresholdA1/ 107;
        AverageLightThresholdA = (AverageLightThresholdA1 + AverageLightThresholdA2 + AverageLightThresholdA3 + AverageLightThresholdA4 + AverageLightThresholdA5)/5;

        AverageLightThresholdB1 = AverageLightThresholdB1/ 107;
        AverageLightThresholdB = (AverageLightThresholdB1 + AverageLightThresholdB2 + AverageLightThresholdB3 + AverageLightThresholdB4 + AverageLightThresholdB5)/5;

        if(AverageLightThresholdA1 != 0.0 && AverageLightThresholdA2 !=0.0 && AverageLightThresholdA3 != 0.0 && AverageLightThresholdA4 != 0.0 && AverageLightThresholdA5 != 0.0) {
        
//        leftLineFound = checkLeftCamera();
//        rightLineFound = checkRightCamera();
        
        //if (leftLineFound && rightLineFound)
//        {
//            if (
//            // difference of right x - left x values < 21, then enter turn speed (possibly slow down by reversing)
//            // with that, we need to be able to read both cameras

            
        
            if (domCamFlag)
            {
                 if(!checkLeftCamera()){
                    if(!checkRightCamera()){
                        hailMary();
                    }
                }
            }
            else
            {
                if(!checkRightCamera()){
                    if(!checkLeftCamera()){
                        hailMary();
                    }
                }
            }
            
            setDriveSpeed();
            if(printFlag){
                pc.printf(", St: %4.3f, Cam: %c", steerDif, domCam);
            }
        }
        if(printFlag) {
//        pc.printf("\n\r");
            pc.printf("\n\r");
        }
        TFC_LineScanImageReady=0;
        firstXR = 0;
        whiteFlagR = 0;
        blackFlagR = 0;
        firstXL = 0;
        whiteFlagL = 0;
        blackFlagL = 0;
        xCountR = 0;
        xCountL = 0;

    }
}


void setColorCharacter(int index)
{
    //Right Camera
//    if(TFC_LineScanImage0[index] < AverageLightThresholdA*thresholdAllowance0) {
//        line0[index-lowLoop] = 'X';
//        if(whiteFlagR == 1) {
//            xCountR ++;
//            if (firstXR ==0 && blackFlagR == 0) {
//                firstXR = index - lowLoop;
//                blackFlagR = 1;
//            }
//        }
//    } 
//    else {
//        line0[index-lowLoop] = ' ';
//        if(whiteFlagR == 0) {
//            whiteFlagR = 1;
//        }
//        if(blackFlagR == 1) {
//            whiteFlagR = 0;
//        }
//
//    }
    //Right Camera
    if(TFC_LineScanImage0[index] < AverageLightThresholdA*thresholdAllowance0) 
    {
        line0[index-lowLoop] = 'X';
        xCountR ++;
        if (firstXR ==0) 
        {
            firstXR = index - lowLoop;
        }
    } 
    else
    {
        line0[index-lowLoop] = ' ';
    }

    //Left Camera
//    if(TFC_LineScanImage1[index] < AverageLightThresholdB*thresholdAllowance1) {
//        line1[index-lowLoop] = 'X';
//        if(whiteFlagL == 1) {
//            xCountL ++;
//            if (firstXL ==0 && blackFlagL == 0) {
//                firstXL = index - lowLoop;
//                blackFlagL = 1;
//            }
//        }
//    } else {
//        line1[index-lowLoop] = ' ';
//        if(whiteFlagL == 0) {
//            whiteFlagL = 1;
//        }
//        if(blackFlagL == 1) {
//            whiteFlagL = 0;
//        }
//    }
    //Left Camera
    if(TFC_LineScanImage1[index] < AverageLightThresholdB*thresholdAllowance1)
    {
        line1[index-lowLoop] = 'X';
        if (index<65)
        {
        xCountL ++;
        firstXL = index - lowLoop;  //???????????????????????????????????
        }
    } 
    else 
    {
        line1[index-lowLoop] = ' ';
    }
}


// servo position 3.5 is MAX
void turn(float val, char mode)
{
    if(mode == 'P')
    {
        TFC_SetServo(0,val);
    }
    else if(mode == 'L')
    {
        TFC_SetServo(0,(val-.5)*0.5);
    }
    else
    {
        if(abs(val) <= .15)
        {
            TFC_SetServo(0, val*0.2);
        }
        else
        {
            TFC_SetServo(0, val*0.5);
        }
        
    }
}


bool checkRightCamera(){
    if(xCountR > 0) {
            if (lastXCountR == -10) {
                lastXCountR = xCountR;
            }
//            if (xCountR < lastXCountR + xCountAllowance && xCountR > lastXCountR - xCountAllowance ) {

                float Xmid = firstXR;//+ xCountR/2;
                steerDif = (Xmid - 33)/33;
//                  pc.printf("   %f",steerDif);
                if (steerFlag) {
                    if ((abs(steerDif - oldSteerDif) < steerDifAllowance) || (steerDifCounter > steerCounterAllowance))
                    {
                        oldSteerDif = steerDif;
                        steerDifCounter = 0;
                    }
                    else
                    {
                        steerDif = oldSteerDif;
                        steerDifCounter++;
                    }
                    domCam = 'R';
                    turn(steerDif, domCam);
                        
//                }

                prayCounter = 0;
                lastXCountL = -10;
                lastXCountR = xCountR;
            }
            return true;
        }
        else{
            return false;
        }
}

bool checkLeftCamera(){
    if(xCountL > 0) {
       // if (lastXCountL == -10) {
//            lastXCountL = xCountL;
//        }
//        if (xCountL < lastXCountL + xCountAllowance && xCountL > lastXCountL - xCountAllowance ) {
            float Xmid = firstXL;
     
            steerDif = 1-(80-Xmid)/81;
            if (steerFlag) {
                if ((abs(steerDif - oldSteerDif) < steerDifAllowance) || (steerDifCounter > steerCounterAllowance))
                    {
                        oldSteerDif = steerDif;
                        steerDifCounter = 0;
                    }
                    else
                    {
                        steerDif = oldSteerDif;
                        steerDifCounter++;
                    }
                domCam = 'L';
                
                turn(steerDif, domCam);
//            }

            prayCounter = 0;
            lastXCountL = xCountL;
            lastXCountR = -10;
        }
        return true;
    }
    else{
        return false;   
    }
}

void hailMary(){
    if (prayCounter < prayMax) 
    {
        prayCounter ++;
        steerDif = steerDif * .2;
        if (steerFlag) 
        {
            turn(steerDif, 'P');
        }

    } 
    else 
    {   
        driveSpeed = 0;
        TFC_SetMotorPWM(-driveSpeed, driveSpeed); // right = A, backwards when positive
    }
    lastXCountR = -10;
    lastXCountL = -10;

}

void setDriveSpeed(){
    //See Both Cameras
    if(xCountR > 0 && xCountL > 0)
    {
        int edgeDifference = firstXR - firstXL;
        if(printFlag){
            pc.printf(", %i", edgeDifference);
        }
        if (edgeDifference > -5 && edgeDifference < 5)
        {   
           driveSpeed = fastSpeed; 
           TFC_SetBatteryLED(15);
        }
        else if (edgeDifference > -10 && edgeDifference < 10)
        {
            driveSpeed = cruiseSpeed;
            TFC_SetBatteryLED(0);
        }
        else
        {
            driveSpeed = turnSpeed;
             TFC_SetBatteryLED(0);
            
        }
    }
    //Only see one camera or zero cameras
    else
    {
         TFC_SetBatteryLED(0);
        if (abs(steerDif) >= .4)
        {   
            driveSpeed = turnSpeed;
        }
        else //if (abs(steerDif) >= .15)
        {
            driveSpeed = cruiseSpeed;
        }
        //else
//        {
//            driveSpeed = fastSpeed;
//        }
    }
        
    if(driveFlag) {
    TFC_SetMotorPWM(-driveSpeed, driveSpeed); // right = A, backwards when positive
    }
    else {
        TFC_SetMotorPWM(0, 0);
    }
}