#include "mbed.h"
#include "mbedOSC.h"

// mbed IP address (server):
#ifdef DHCP
EthernetNetIf eth;
#else
EthernetNetIf eth(
    IpAddr(192,168,12,210),//your mbed IP Address
    IpAddr(255,255,255,0),//Network Mask
    IpAddr(),//Gateway
    IpAddr()//DNS
);
#endif

//receive
uint8_t receiveIp[] = { 192, 168, 12, 210 };//IP Address
int receivePort     = 5678;//port

//destination.
uint8_t destIp[] = { 192, 168, 12, 51};//IP Address
int destPort     = 10000;//port

//send value propaty.
char *topAddress = "/mbed";
char *subAddress[3] = {"/test1","/test2","/test3"};

//receive value propaty
char *requestTopStr[3] = {"mbed1","mbed2","mbed3"};
char *requestSubStr[3] = {"test1","test2","test3"};

//instance
OSCMessage recMes;
OSCMessage sendMes;
OSCClass osc;
//OSCClass osc(&recMes);  // instantiate OSC communication object, and set the receiver container from the OSC packets
Serial pc(USBTX, USBRX);

//LED
DigitalOut led(LED1);

void processOSC(UDPSocketEvent e);

int main()
{
    // Set the Ethernet port:
    EthernetErr ethErr = eth.setup();
    if(ethErr) {
        //error
        return -1;
    }


    //(1) Sending message >>>
    // Set IP and Port:
    sendMes.setIp( destIp );
    sendMes.setPort( destPort );

    //(2) Receiving <<<
    recMes.setIp(receiveIp);
    osc.setReceiveMessage(&recMes); // this sets the receiver container for the OSC packets (we can avoid doing this if we use osc.getMessage() to get messages)
    osc.begin(receivePort, &processOSC); // binds the upd (osc) messages to an arbitrary listening port ("server" port), and callback function

    //loop
    while(true) {
        Net::poll();

        //Set data
        sendMes.setTopAddress(topAddress);//top address
        sendMes.setSubAddress(subAddress[0]);//sub address
        sendMes.setArgs("i", 1);//type , value

        osc.sendOsc(&sendMes);//send!
    }
}


//osc callback function
void processOSC(UDPSocketEvent e)
{
    osc.onUDPSocketEvent(e);

    if (osc.newMessage) {
    
        osc.newMessage = false; // note: if using: message = osc.getMessage(), then we don't need to do this explicitly.

        //(strcmp(str1,str2)==0)
        //if ... str1 = str2 >>> same
        if(strcmp(recMes.getAddress(0),requestTopStr[0])==0) {
            if(strcmp(recMes.getAddress(1),requestSubStr[0])==0) {
                led = 1;//led HIGH
                wait(0.2);
                led = 0;//led LOW
                wait(0.2);
                led = 1;//led HIGH
                wait(0.2);
                led = 0;//led LOW
                wait(0.2);
                led = 1;//led HIGH
                wait(0.2);
                led = 0;//led LOW
                wait(0.2);
            }
        } else {
            //action
            led = 0;//led LOW
        }
    }
}