#include "mbed.h"
#include "EthernetNetIf.h"
#include "UDPSocket.h"
#include "Control.h"

extern "C" void mbed_reset();

//#define
#define INPUT_PORT 5678

#ifdef DHCP
EthernetNetIf eth;
#else
EthernetNetIf eth(
  IpAddr(192,168,12,210), //IP Address
  IpAddr(255,255,255,0), //Network Mask
  IpAddr(), //Gateway
  IpAddr()  //DNS
);
#endif

Serial pc(USBTX, USBRX);

LedControl ledControl;

DigitalOut led1(LED1);

//--- OSC related stuff ---
union OSCarg {
// char*, int and float are assumed four bytes
        char *address;
        char *typeTag;
        int i;
        float f;
        char *s;
        struct {
            int len; // is "int i"
            char *p;
        } blob;
        char m[4];  // for MIDI
        char _b[4]; // endian conversion temp variable
};

void getOSCmsg(char *packet , union OSCarg *msg){
// Caution: the returned result points to packet as blobs or strings (not newly allocatd)
    char *p, *typeTag; char c;
        
    msg[0].address = packet; // address
    msg[1].typeTag = packet+4*(strlen(msg[0].s)/4+1);//typeTag
    typeTag=msg[1].s+1; // skip ','
    p= msg[1].s+4*(strlen(msg[1].s)/4+1);
    for(int n=0; n<strlen(typeTag); n++){
        c = typeTag[n];
        if (('s'==c)) {
            msg[n+2].s=p;
            p += 4*(strlen(msg[n+2].s)/4+1);
        } else if (('i'==c)||('f'==c)) {
            // chang endian (big to little)
            msg[n+2]._b[3]=p[0]; 
            msg[n+2]._b[2]=p[1]; 
            msg[n+2]._b[1]=p[2];
            msg[n+2]._b[0]=p[3];
            p +=4;  
        } else if ('b'==c) {
            // chang endian (big to little)
            // get lenth of blog (copy to msg[n].blog.len)
            msg[n+2]._b[3]=p[0]; 
            msg[n+2]._b[2]=p[1]; 
            msg[n+2]._b[1]=p[2];
            msg[n+2]._b[0]=p[3];
            p +=4;  
            // get ponter of blog (copy to msg[n].blog.p)
            msg[n+2].blob.p=p;
            p += 4*(msg[n+2].blob.len/4+1);       
        } else if ('m'==c) {
            // get midi data (copy to msg[n].m[])
            msg[n+2].m[0]=p[0]; 
            msg[n+2].m[1]=p[1]; 
            msg[n+2].m[2]=p[2];
            msg[n+2].m[3]=p[3];
            p +=4;  
        } else {
            printf("*** Not Supported TypeTag:%s ****\n",typeTag);
        }
    };
}
//-------------------------------------------

UDPSocket udp;

void onUDPSocketEvent(UDPSocketEvent e)
{
  union OSCarg msg[10];
  
  printf("receive.");

  switch(e)
  {
  case UDPSOCKET_READABLE: //The only event for now
    char buf[256] = {0};
    Host host;
    while( int len = udp.recvfrom( buf, 256, &host ) )
    {
      if( len <= 0 )
        break;
      printf("\r\nFrom %d.%d.%d.%d:\r\n", 
      host.getIp()[0], host.getIp()[1], host.getIp()[2], host.getIp()[3]);
      
      getOSCmsg(buf,msg);
      
      if(msg[2].i==101)
      {
        ledControl.colorChase(127,127,127,3);//(r,g,b,delay)
        
//        colorChase(strip.Color(127,127,127), 3);//white
//        led = 1;
//        wait(0.2);
//        led = 0;
        printf("led blink complete.");
      }

      printf("OSCmsg >>> %s %s %d\n", 
            msg[0].address, msg[1].typeTag,msg[2].i);
    }
    break;
  }
}

int main() 
{
  printf("Ethernet Setup..............................\r\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\r\n", ethErr);
    return -1;
  }
  printf("Ethernet Setup Complete..............................\r\n");
  
  printf("Address&Port Setup..............................\r\n");
  // port setup
  Host recHost(IpAddr(192, 168, 12, 210), INPUT_PORT, NULL);
  udp.setOnEvent(&onUDPSocketEvent);
  udp.bind(recHost);
  printf("Address&Port Setup Complete..............................\r\n");
    
  while(true)
  {
    Net::poll();
        
    printf(".");
  } 
}