// standard connected to 1st hardware SPI
// LPD8806  <> MBED
// DATA     -> P5( mosi ) or P11( mosi )
// CLOCK    -> p7( sclk ) or p13( sclk )
/*****************************************************************************/
#include "mbed.h"
#include "mbedOSC.h"
#include "LPD8806.h"

extern "C" void mbed_reset();

//OSC setup----------------------------------------------------------------------
// mbed IP address (server):
//#ifdef DHCP
//EthernetNetIf eth;
//#else
EthernetNetIf eth(
    IpAddr(192,168,12,210),//my mbed IP Address
    IpAddr(255,255,255,0),//Network Mask
    IpAddr(),//Gateway
    IpAddr()//DNS
);
//#endif

//receive
uint8_t receiveIp[] = { 192, 168, 12, 210 };//IP Address
int receivePort     = 5678;//port

//destination.
uint8_t destIp[] = { 192, 168, 12, 51};//IP Address
int destPort     = 10000;//port

//send value propaty.
char *topAddress    = "/hangers";
char *subAddress[3] = {"/line1","/line2","/line3"};

//receive value propaty
char *requestStr       = "hangers";
char *requestTopStr[3] = {"mbed1","mbed2","mbed3"};
char *requestSubStr[3] = {"test1","test2","test3"};
int requestNumber[10]  = {101,102,103,104,105,106,107,108,109,110};
const int resetNumber  = 777;

//instance
OSCMessage recMes;
OSCMessage sendMes;
OSCClass osc;

//digital pin
DigitalOut csPin1(p8);
DigitalOut csPin2(p9);
DigitalOut csPin3(p10);
DigitalOut csPin4(p21);
DigitalOut csPin5(p22);
DigitalOut csPin6(p23);
DigitalOut csPin7(p24);
DigitalOut csPin8(p25);
DigitalOut csPin9(p26);
DigitalOut led(LED1);

//mode
bool sendMode = false;
bool receiveMode = true;
//----------------------------------------------------------------------

LPD8806 strip = LPD8806(10);

//LOW
void low()
{
    for (int i=0; i < strip.numPixels(); i++) {
        strip.setPixelColor(i, 0);  // turn all pixels off
    }
    strip.show();
    
    printf("low complete.");
}

//HIGH
void high(uint32_t c)
{
    for (int i=0; i < strip.numPixels(); i++) {
        strip.setPixelColor(i, c);  // turn all pixels off
    }
    strip.show();
    
    printf("high complete.");
}

//FADE
void fade(uint16_t colorNum,uint8_t delay)
{
    //fade in
    for(int i = 0; i < colorNum; i++)
    {
        for(int j = 0; j < strip.numPixels(); j++)
        {
            strip.setPixelColor(j,strip.Color(i,i,i));
        }
        strip.show();
        wait_ms(delay);
    }
    
    //fade out
    for(int i = colorNum; i > 0; i--)
    {
        for(int j = 0; j < strip.numPixels(); j++)
        {
            strip.setPixelColor(j,strip.Color(i,i,i));
        }
        strip.show();
        wait_ms(delay);
    }
    //low
    low();
    
    printf("fade complete.");
}

// Chase a dot down the strip
// good for testing purposes
void colorChase(uint32_t c, uint8_t delay) {
    int i;

    for (i=0; i < strip.numPixels(); i++) {
        strip.setPixelColor(i, 0);  // turn all pixels off
    }

    for (i=0; i < strip.numPixels(); i++) {
        strip.setPixelColor(i, c);
        if (i == 0) {
            strip.setPixelColor(strip.numPixels()-1, 0);
        } else {
            strip.setPixelColor(i-1, 0);
        }
        strip.show();
        wait_ms(delay);
    }
}

// fill the dots one after the other with said color
// good for testing purposes
void colorWipe(uint32_t c, uint8_t delay) {
    int i;

    for (i=0; i < strip.numPixels(); i++) {
        strip.setPixelColor(i, c);
        strip.show();
        wait_ms(delay);
    }
}

//Input a value 0 to 384 to get a color value.
//The colours are a transition r - g -b - back to r

uint32_t Wheel(uint16_t WheelPos) {
    uint8_t b=0;
    uint8_t g=0;
    uint8_t r = 0;
    switch (WheelPos / 128) {
        case 0:
            r = 127 - WheelPos % 128;   //Red down
            g = WheelPos % 128;      // Green up
            b = 0;                  //blue off
            break;
        case 1:
            g = 127 - WheelPos % 128;  //green down
            b = WheelPos % 128;      //blue up
            r = 0;                  //red off
            break;
        case 2:
            b = 127 - WheelPos % 128;  //blue down
            r = WheelPos % 128;      //red up
            g = 0;                  //green off
            break;
    }
    return(strip.Color(r,g,b));
}

void rainbow(uint8_t delay) {
    int i, j;

    for (j=0; j < 384; j++) {     // 3 cycles of all 384 colors in the wheel
        for (i=0; i < strip.numPixels(); i++) {
            strip.setPixelColor(i, Wheel( (i + j) % 384));
        }
        strip.show();   // write all the pixels out
        wait_ms(delay);
    }
}

// Slightly different, this one makes the rainbow wheel equally distributed
// along the chain
void rainbowCycle(uint8_t delay) {
    uint16_t i, j;

    for (j=0; j < 384 * 5; j++) {     // 5 cycles of all 384 colors in the wheel
        for (i=0; i < strip.numPixels(); i++) {
            // tricky math! we use each pixel as a fraction of the full 384-color wheel
            // (thats the i / strip.numPixels() part)
            // Then add in j which makes the colors go around per pixel
            // the % 384 is to make the wheel cycle around
            strip.setPixelColor(i, Wheel( ((i * 384 / strip.numPixels()) + j) % 384) );
        }
        strip.show();   // write all the pixels out
        wait_ms(delay);
    }
}

// "Larson scanner" = Cylon/KITT bouncing light effect
void scanner(uint8_t r, uint8_t g, uint8_t b, uint8_t delay) {
    int i, j, pos, dir;

    pos = 0;
    dir = 1;

    for (i=0; i<((strip.numPixels()-1) * 8); i++) {
        // Draw 5 pixels centered on pos.  setPixelColor() will clip
        // any pixels off the ends of the strip, no worries there.
        // we'll make the colors dimmer at the edges for a nice pulse
        // look
        strip.setPixelColor(pos - 2, strip.Color(r/4, g/4, b/4));
        strip.setPixelColor(pos - 1, strip.Color(r/2, g/2, b/2));
        strip.setPixelColor(pos, strip.Color(r, g, b));
        strip.setPixelColor(pos + 1, strip.Color(r/2, g/2, b/2));
        strip.setPixelColor(pos + 2, strip.Color(r/4, g/4, b/4));

        strip.show();
        wait_ms(delay);
        // If we wanted to be sneaky we could erase just the tail end
        // pixel, but it's much easier just to erase the whole thing
        // and draw a new one next time.
        for (j=-2; j<= 2; j++)
            strip.setPixelColor(pos+j, strip.Color(0,0,0));
        // Bounce off ends of strip
        pos += dir;
        if (pos < 0) {
            pos = 1;
            dir = -dir;
        } else if (pos >= strip.numPixels()) {
            pos = strip.numPixels() - 2;
            dir = -dir;
        }
    }
}

void processOSC(UDPSocketEvent e);

//osc callback function
void processOSC(UDPSocketEvent e)
{
    osc.onUDPSocketEvent(e);
    
    printf("new message!!");

    if (osc.newMessage)
    {
//        osc.newMessage = false; // note: if using: message = osc.getMessage(), then we don't need to do this explicitly.
        
        if(strcmp(recMes.getAddress(0),requestStr)==0)
        {
            int val = recMes.getArgInt(0);
            
            switch(val)
            {
                case 101:
                    //action
//                    led = 1;
//                    wait(0.2);
//                    led = 0;//led LOW
//                    wait(0.2);
                    
                    printf("\n");
                    printf("receive ... 101\n");
                    printf("\n");
                    
//                    fade(127,2);
                    high(strip.Color(127,127,127));
                    wait(1.0);
                    low();
                    wait(1.0);

                    printf("101 ... complete.\n");
                    break;
                case 102:
                
                    printf("\n");
                    printf("receive ... 102\n");
                    printf("\n");
                
                    //action
                    led = 1;
                    wait(0.2);
                    led = 0;//led LOW
                    wait(0.2);
                    led = 1;
                    wait(0.2);
                    led = 0;//led LOW
                    wait(0.2);
                    
                    printf("102 ... complete.\n");
                    break;
                case 103:
                
                    printf("\n");
                    printf("receive ... 103\n");
                    printf("\n");
                
                    //action
                    led = 1;
                    wait(1.0);
                    led = 0;//led LOW
                    wait(1.0);
                    led = 1;
                    wait(1.0);
                    led = 0;//led LOW
                    wait(1.0);
                    led = 1;
                    wait(1.0);
                    led = 0;//led LOW
                    wait(1.0);
                    printf("103 ... complete.\n");
                    break;
                case 104:
                    //action
                    break;
                case 105:
                    //action
                    break;
                case 106:
                    //action
                    break;
                case 107:
                    //action
                    break;
                case 108:
                    //action
                    break;
                case 109:
                    //action
                    break;
                case resetNumber://reset
                    mbed_reset();
                    break;
                default:
                    break;
            }
        }
    }
}

void pinStatusChange(int st1=0,int st2=0,int st3=0,int st4=0,int st5=0,int st6=0,int st7=0,int st8=0)
{
    csPin1 = st1;
    csPin2 = st2;
    csPin3 = st3;
    csPin4 = st4;
    csPin5 = st5;
    csPin6 = st6;
    csPin7 = st7;
    csPin8 = st8;
}

int main(void)
{
    //chip select pin setup
    csPin1 = 1;
    csPin2 = 1;
    csPin3 = 1;
    csPin4 = 1;
    csPin5 = 1;
    csPin6 = 1;
    csPin7 = 1;
    csPin8 = 1;
    csPin9 = 1;

    // Start up the LED strip
    strip.begin();

    // Update the strip, to start they are all 'off'
    strip.show();
    
    // Set the Ethernet port:
    EthernetErr ethErr = eth.setup();
    if(ethErr)
    {
        //error
        return -1;
    }


    //(1) Sending message >>>
    // Set IP and Port:
    if(sendMode)
    {
        sendMes.setIp( destIp );
        sendMes.setPort( destPort );
    }

    //(2) Receiving <<<
    if(receiveMode)
    {
        recMes.setIp(receiveIp);
        osc.setReceiveMessage(&recMes); // this sets the receiver container for the OSC packets (we can avoid doing this if we use osc.getMessage() to get messages)
        osc.begin(receivePort, &processOSC); // binds the upd (osc) messages to an arbitrary listening port ("server" port), and callback function
    }
    
    //loop
    while (receiveMode||sendMode)
    {
        printf("loop...");
    
        Net::poll();
//            
//        if(sendMode)
//        {
//            sendMes.setTopAddress(topAddress);//top address
//            sendMes.setSubAddress(subAddress[0]);//sub address
//            sendMes.setArgs("i", 1);//type , value
//            osc.sendOsc(&sendMes);//send!   
//        }

//        high(strip.Color(127,127,127));
//        wait(1.0);
//        low();
//        wait(1.0);

//        fade(127,5);
//        wait(1.0);
//        scanner(127,127,127,0);//white,slow
        
//        colorChase(strip.Color(127,127,127), 2);//white
//        wait(1.0);
//
//        pinStatusChange(1,1,1,1,1,1,1,1);//pin status change
//        colorChase(strip.Color(127,127,127), 1);//white
//        wait(0.2);
//
//        pinStatusChange(0,0,0,0,0,0,0,0);//pin status change
//        colorChase(strip.Color(127,127,127), 1);//white
//        wait(0.2);
//
//        pinStatusChange(1,1,0);//pin status change
//        colorChase(strip.Color(127,127,127), 1);//white
//        wait(0.2);
//        
//        pinStatusChange(0,1,1);//pin status change
//        colorChase(strip.Color(127,127,127), 1);//white
//        wait(0.2);
//        
//        pinStatusChange(0,0,1);//pin status change
//        colorChase(strip.Color(127,127,127), 1);//white
//        wait(0.2);
//
//        pinStatusChange(0,0,0);//pin status change
//        colorChase(strip.Color(127,127,127), 1);//white
//        wait(0.2);
        
    }

    //loop
//    while(1)
//    {        
        /*
            sample
        */
//        allBlink(strip.Color(127,127,127));
//        colorChase(strip.Color(127,127,127), 2);//white
//        colorWipe(strip.Color(127,127,127), 2);//white
//        colorChase(strip.Color(127,0,0), 10);      // full brightness red
//        colorChase(strip.Color(127,127,0), 10);    // orange
//        colorChase(strip.Color(0,127,0), 10);        // green
//        colorChase(strip.Color(0,127,127), 10);    // teal
//        colorChase(strip.Color(0,0,127), 10);        // blue
//        colorChase(strip.Color(127,0,127), 10);    // violet
//        // fill the entire strip with...
//        colorWipe(strip.Color(127,0,0), 1000);        // red
//        colorWipe(strip.Color(0, 127,0), 10);        // green
//        colorWipe(strip.Color(0,0,127), 10);        // blue
//        rainbow(10);
//        rainbowCycle(5);  // make it go through the cycle fairly fast
//        // Back-and-forth lights
//        scanner(127,0,0, 50);        // red, slow
//        scanner(0,0,127, 5);        // blue, fast
    
        //Set data
//        if(sendMode)
//        {
//            Net::poll();
//            
//            sendMes.setTopAddress(topAddress);//top address
//            sendMes.setSubAddress(subAddress[0]);//sub address
//            sendMes.setArgs("i", 1);//type , value
//            osc.sendOsc(&sendMes);//send!
//        }
//    }
}