#include "mbed.h"
#include "Adresar.h"
#include "main.h"
#define ARRAY_SIZE(array) sizeof(array)/sizeof(*array)

Serial term(USBTX, USBRX);
DigitalOut led1(LED2);

/*********************hlavna cas programu*****************************************/

int main() {
    
    term.baud(57600);
    term.attach(&prijmiSpravu, Serial::RxIrq);

    disp.attach(&disp_Vyt, 0.5);
    sleduj_cas.attach(&watchdog, 1.4);
    acc.MotionDetection(&EM);
    init();
      
    //int aDataIn[] = {*prerusVysielanie()};
    // int dataSize1 = ARRAY_SIZE(aDataIn);
   // posliSpravu(0xD0,0xAA,dataSize1,aDataIn);
   
  
  while(1){
    tlacitka();
    }
}
/*********************riadneie komunikacie*****************************************/

/*
vypocet CRC

*/

int getCrc(int addrRx, int addrTx, int dataSize, int aData[])
{
    int aCRC[] =   {0, 94, 188, 226, 97, 63, 221, 131, 194, 156, 126, 32, 163, 253, 31, 65,
                    157, 195, 33, 127, 252, 162, 64, 30, 95, 1, 227, 189, 62, 96, 130, 220,
                    35, 125, 159, 193, 66, 28, 254, 160, 225, 191, 93, 3, 128, 222, 60, 98,
                    190, 224, 2, 92, 223, 129, 99, 61, 124, 34, 192, 158, 29, 67, 161, 255,
                    70, 24, 250, 164, 39, 121, 155, 197, 132, 218, 56, 102, 229, 187, 89, 7,
                    219, 133, 103, 57, 186, 228, 6, 88, 25, 71, 165, 251, 120, 38, 196, 154,
                    101, 59, 217, 135, 4, 90, 184, 230, 167, 249, 27, 69, 198, 152, 122, 36,
                    248, 166, 68, 26, 153, 199, 37, 123, 58, 100, 134, 216, 91, 5, 231, 185,
                    140, 210, 48, 110, 237, 179, 81, 15, 78, 16, 242, 172, 47, 113, 147, 205,
                    17, 79, 173, 243, 112, 46, 204, 146, 211, 141, 111, 49, 178, 236, 14, 80,
                    175, 241, 19, 77, 206, 144, 114, 44, 109, 51, 209, 143, 12, 82, 176, 238,
                    50, 108, 142, 208, 83, 13, 239, 177, 240, 174, 76, 18, 145, 207, 45, 115,
                    202, 148, 118, 40, 171, 245, 23, 73, 8, 86, 180, 234, 105, 55, 213, 139,
                    87, 9, 235, 181, 54, 104, 138, 212, 149, 203, 41, 119, 244, 170, 72, 22,
                    233, 183, 85, 11, 136, 214, 52, 106, 43, 117, 151, 201, 74, 20, 246, 168,
                    116, 42, 200, 150, 21, 75, 169, 247, 182, 232, 10, 84, 215, 137, 107, 53
                   };              
    int crc = 0;
    crc = aCRC[crc ^ addrRx];
    crc = aCRC[crc ^ addrTx];
    for(int i = 0; i < dataSize; i++){
        crc = aCRC[crc ^ aData[i]];
    }
    return crc;    
}

/*
odoslanie spravy
*/

void posliSpravu(int addrRx, int addrTx,int dataSize, int aData[])
 {
     
     int aPacket[5+dataSize];
    aPacket[0] = 0xA0;
    aPacket[1] = addrRx;
    aPacket[2] = addrTx;
    aPacket[3] = dataSize;
    
    for(int i = 0; i < dataSize; i++){
        aPacket[4+i] = aData[i];
    }
    
    int crc = getCrc(addrRx, addrTx, dataSize, aData);
    aPacket[4+dataSize] = crc;
    
    
    prijmi = 0;
    
    for(int i = 0; i < ARRAY_SIZE(aPacket); i++){
        term.putc(aPacket[i]);       
    }
}
/*
prijatie spavy 
*/
void prijmiSpravu()
{
   
    
    prijmi = 1;
    for(int i = 0; i < 4; i++) {
        adresa[i] = term.getc();
    }
    
   
    if(adresa[3] == 0x00) {
        sprava[0] = term.getc();
    }else{        
        for(int i = 0; i < adresa[3]; i++){
            sprava[i]=term.getc();  
        }
        adresa[4]=term.getc();
        if(adresa[4] == getCrc(adresa[1], adresa[2],adresa[3],sprava)){
          
        }
    }
    
       logikaRiadenia();
   
}
/*********************bezpecnost*****************************************/

/*
uvolnenie EM
*/
void uvolniEM()
{
    int aDataIn[] = {0x00};
    int dataSize1 = ARRAY_SIZE(aDataIn);
    posliSpravu(EM_BRAKE,0xAA,dataSize1,aDataIn);
    
    }
    
    /*
        spustenie EM
    */
    void EM()
    {
        
    int aDataIn[] = {0x01};
    int dataSize1 = ARRAY_SIZE(aDataIn);
    posliSpravu(EM_BRAKE,0xAA,dataSize1,aDataIn);
        }
        
        /*
        resetovanie watchdog pri spusteny programu
        */
    
    void resWatch()
    {
        int aDataIn[] = {0x01};
        int dataSize1 = ARRAY_SIZE(aDataIn);
        posliSpravu(WATCHDOG,0xAA,dataSize1,aDataIn);
        
        }
        
        /*
        celkova logika riadenia vytahu
        */
/*********************riadneie obsluhy vytahu*****************************************/
void logikaRiadenia(){
    
    if(init_flag == 1){
        if (dajPoschodie() == SWITCH_P){ 
            stop();  
            init_flag = 0;
            poschodie = 0;
        }
        } else {
    
    if(p_0 == 1)
    {
        if (dajPoschodie() == SWITCH_P){ 
            ledPoff();
            ledPoffC();
            stop();  
            odomkniVytah() ;
            poschodie = 0;
            p_0 = 0;
        }    
        
        }
        
         
    if(p_1 == 1)
    {
        if (dajPoschodie() == SWITCH_1){ 
            led1off();
            led1offC();
            stop();  
            odomkniVytah() ;
            poschodie = 1;
            p_1 = 0;
        }    
        
        }
        
        if(p_2 == 1)
    {
        if (dajPoschodie() == SWITCH_2){ 
            led2off();
            led2offC();
            stop();  
            odomkniVytah() ;
            poschodie = 2;
            p_2 = 0;
        }    
        
        }
    
    if (p_3 == 1){
        
        if (dajPoschodie() == SWITCH_3){ 
            led3off();
            led3offC();
            stop();  
            odomkniVytah() ;
            poschodie = 3;
            p_3 = 0;
        }    
    }
    
    if(p_4 == 1)
    {
        if (dajPoschodie() == SWITCH_4){ 
            led4off();
            led4off();
            stop();  
            odomkniVytah() ;
            poschodie = 4;
            p_4 = 0;
        }    
        
        }
        }
    
    }


/*
obsluha tlacitok vo vytahu a na stene poschodia
*/

void tlacitka()
{
    
    switch(adresa[2])
       {
           case W_P_BUTTON:
           {
                p_0 = 1;
                ledPon();
                
                if (poschodie > 0)
                {
                    smerDole();
                    } else if (poschodie < 0)
                    {
                        smerHore();
                        }
                         else 
                        {
                            p_0 = 0;
                            ledPoff();
                            }
                
                break;
               }
               
               case W_1_BUTTON:
           {
                p_1 = 1;
                led1on();
                if (poschodie > 1)
                {
                    smerDole();
                    } else if (poschodie < 1)
                    {
                        smerHore();
                        } else 
                        {
                            p_1 = 0;
                            led1off();
                            }
                
                break;
               }
               
               case W_2_BUTTON:
           {
                p_2 = 1;
                led2on();
                if (poschodie > 2)
                {
                    smerDole();
                    } else if (poschodie < 2)
                    {
                        smerHore();
                        }
                         else 
                        {
                            p_2 = 0;
                            led2off();
                            }
                break;
               }
               
               case W_3_BUTTON:
           {
                p_3 = 1;
                led3on();
                if (poschodie > 3)
                {
                    smerDole();
                    } else if (poschodie < 3)
                    {
                        smerHore();
                        }
                         else 
                        {
                            p_3 = 0;
                            led3off();
                            }
    
                break;
               }
               
               case W_4_BUTTON:
           {
                p_4 = 1;
                led4on();
                if (poschodie > 4)
                {
                    smerDole();
                    } else if (poschodie < 4)
                    {
                        smerHore();
                        }
                         else 
                        {
                            p_4 = 0;
                            led4off();
                            }
                break;
               }
               
                case C_P_BUTTON:
           {
                p_0 = 1;
                ledPonC();
                if (poschodie > 0)
                {
                    smerDole();
                    } else if (poschodie < 0)
                    {
                        smerHore();
                        }
                         else 
                        {
                            p_0 = 0;
                            ledPoffC();
                            }
                break;
               }
               
               case C_1_BUTTON:
           {
                p_1 = 1;
                led1onC();
                if (poschodie > 1)
                {
                    smerDole();
                    } else if (poschodie < 1)
                    {
                        smerHore();
                        }
                         else 
                        {
                            p_1 = 0;
                            led1off();
                            }
                break;
               }
               
               case C_2_BUTTON:
           {
                p_2 = 1;
                led2onC();
                if (poschodie > 2)
                {
                    smerDole();
                    } else if (poschodie < 2)
                    {
                        smerHore();
                        }
                         else 
                        {
                            p_2 = 0;
                            led2offC();
                            }
                break;
               }
               
               case C_3_BUTTON:
           {
                p_3 = 1;
                led3onC();
                if (poschodie > 3)
                {
                    smerDole();
                    } else if (poschodie < 3)
                    {
                        smerHore();
                        }
                         else 
                        {
                            p_3 = 0;
                            led3offC();
                            }
                break;
               }
               
               case C_4_BUTTON:
           {
                p_4 = 1;
                led4onC();
                if (poschodie > 4)
                {
                    smerDole();
                    } else if (poschodie < 4)
                    {
                        smerHore();
                        }
                         else 
                        {
                            p_4 = 0;
                            led4offC();
                            }
                break;
               }
              
               
               
           
           }
 
    }
    
    
   /*
   posiela watchdogu ze zije logika
   */ 
void watchdog()
{
        int aDataIn[] = {0x03};
        int dataSize1 = ARRAY_SIZE(aDataIn);
        posliSpravu(WATCHDOG,0xAA,dataSize1,aDataIn);
    }    


/*
vratenie poschodia
*/

int dajPoschodie()
{
     int poschodie;
     
     switch(adresa[2])
     {
         case SWITCH_P:
         {
             poschodie =  SWITCH_P;
             cisloPochodia_dislpej = 0;
            break;
             }
             
          case SWITCH_1:
          {
              poschodie =  SWITCH_1;
              cisloPochodia_dislpej = 1;
              break;
              }
              case SWITCH_2:
              {
                  poschodie = SWITCH_2;
                  cisloPochodia_dislpej = 2;
              break;
                  }
                  
                  case SWITCH_3:
              {
                  poschodie = SWITCH_3;
                  cisloPochodia_dislpej = 3;
              break;
                  }
                  case SWITCH_4:
              {
                  poschodie = SWITCH_4;
                  cisloPochodia_dislpej = 4;
              break;
                  }
                  
                  
         
         }
         
         return poschodie;
    
    }


/*
inicializcia vytahu
*/


void init(){
    init_flag = 1;
    uvolniEM();
    resWatch();
    smerDole();
    }


/*
zastavenie vytahu
*/
void stop()
{
    int aDataIn[] = {0x1};
    int dataSize1 = ARRAY_SIZE(aDataIn);
    posliSpravu(MOTOR,0xAA,dataSize1,aDataIn);
    odomkniVytah();
    }

/*
pohyb hore postupne pridavanie rychlosti
*/

void smerHore()
{
      zamkniVytah();
      pohyb++;
        if(pohyb_flag == 0){
            pohyb_flag = 1;
            zamkniVytah();
            int aDataIn[] = {0x2, 0x64, 0x00, 0x00, 0x00};
            int dataSize = ARRAY_SIZE(aDataIn);
            posliSpravu(MOTOR,0x00,dataSize, aDataIn); 
            smerJazdy = 1;
            
        }
        if(pohyb > 2){
            pohyb = 0;
            pohyb_flag = 1;
            zamkniVytah();
            int aDataIn[] = {0x2, 0x64, 0x00, 0x00, 0x00};
            int dataSize = ARRAY_SIZE(aDataIn);
            posliSpravu(MOTOR,0x00,dataSize, aDataIn); 
            smerJazdy = 1;    
            
        } 
     
}

/*
pohyb hore postupne pridavanie rychlosti
*/

void smerDole()
{
         
     zamkniVytah();
     
     pohyb++;
        if(pohyb_flag == 0){
            pohyb_flag = -1;
            zamkniVytah();
            int aDataIn[] = {0x2, 0x9C, 0xff, 0xff, 0xff};
            int dataSize = ARRAY_SIZE(aDataIn);
            posliSpravu(MOTOR,0x00,dataSize, aDataIn); 
            smerJazdy = -1;
            
        }
        if(pohyb > 2){
            pohyb = 0;
            pohyb_flag = -1;
            zamkniVytah();
            int aDataIn[] = {0x2, 0x9C, 0xff, 0xff, 0xff};
            int dataSize = ARRAY_SIZE(aDataIn);
            posliSpravu(MOTOR,0x00,dataSize, aDataIn); 
            smerJazdy = -1;   
            
        }
    
}


/*
uzamknutie vytahu
*/
 void zamkniVytah()
 {
     int adata[1] = {0x01};
    int dataSize = ARRAY_SIZE(adata);
     posliSpravu(0xF0,0xAA,dataSize,adata);
     
}

/*
odomknutie vytahu
*/

void odomkniVytah()
{
    int adata[1] = {0x00};
    int dataSize = ARRAY_SIZE(adata);
     posliSpravu(0xF0,0xAA,dataSize,adata);
    }
    
    /*
    obsluha displeja vytahu
    */
    
void disp_Vyt()
{
        int aDataIn[2];
    int dataSize = ARRAY_SIZE(aDataIn);  
    switch(pohyb_flag){
        case 0:{
            aDataIn[0] = 0x03;
            break;    
        }
        case 1:{
            aDataIn[0] = 0x01;
            break;    
        } 
        case -1:{
            aDataIn[0] = 0x02; 
            break;   
        }     
    }
    switch(cisloPochodia_dislpej){
        case 0:{
            aDataIn[1] = 0x50;   
            break; 
        } 
        case 1:{
            aDataIn[1] = 0x31;   
            break; 
        }
        case 2:{
            aDataIn[1] = 0x32;   
            break; 
        }
        case 3:{
            aDataIn[1] = 0x33;   
            break; 
        }
        case 4:{
            aDataIn[1] = 0x34;   
            break; 
        }   
    }
    if(cisloPochodia_dislpej != disp_poschodie){
        posliSpravu(C_LCD,0x00,dataSize, aDataIn); 
    }else if(pohyb_flag != display_smer){
        posliSpravu(C_LCD,0x00,dataSize, aDataIn);     
    }
    disp_poschodie = cisloPochodia_dislpej; 
    display_smer = pohyb_flag; 
}
/**********************raiadenie lediek vytahu*********************************/
void ledPon()
{
    int aDataIn[] = {0x1};
    int dataSize1 = ARRAY_SIZE(aDataIn);
    posliSpravu(0x10,0xAA,dataSize1,aDataIn);
    }
    
    void led1on()
{
    int aDataIn[] = {0x1};
    int dataSize1 = ARRAY_SIZE(aDataIn);
    posliSpravu(0x11,0xAA,dataSize1,aDataIn);
    }
    
    void led2on()
{
    int aDataIn[] = {0x1};
    int dataSize1 = ARRAY_SIZE(aDataIn);
    posliSpravu(0x12,0xAA,dataSize1,aDataIn);
    }
    
    void led3on()
{
    int aDataIn[] = {0x1};
    int dataSize1 = ARRAY_SIZE(aDataIn);
    posliSpravu(0x13,0xAA,dataSize1,aDataIn);
    }
    
    void led4on()
{
    int aDataIn[] = {0x1};
    int dataSize1 = ARRAY_SIZE(aDataIn);
    posliSpravu(0x14,0xAA,dataSize1,aDataIn);
    }
    
    
    
    void ledPoff()
{
    int aDataIn[] = {0x0};
    int dataSize1 = ARRAY_SIZE(aDataIn);
    posliSpravu(0x10,0xAA,dataSize1,aDataIn);
    }
    
    void led1off()
{
    int aDataIn[] = {0x0};
    int dataSize1 = ARRAY_SIZE(aDataIn);
    posliSpravu(0x11,0xAA,dataSize1,aDataIn);
    }
    
    void led2off()
{
    int aDataIn[] = {0x0};
    int dataSize1 = ARRAY_SIZE(aDataIn);
    posliSpravu(0x12,0xAA,dataSize1,aDataIn);
    }
    
    void led3off()
{
    int aDataIn[] = {0x0};
    int dataSize1 = ARRAY_SIZE(aDataIn);
    posliSpravu(0x13,0xAA,dataSize1,aDataIn);
    }
    
    void led4off()
{
    int aDataIn[] = {0x0};
    int dataSize1 = ARRAY_SIZE(aDataIn);
    posliSpravu(0x14,0xAA,dataSize1,aDataIn);
    }
   
   
   /************************************************************************************/ 
   
   
   void ledPonC()
{
    int aDataIn[] = {0x1};
    int dataSize1 = ARRAY_SIZE(aDataIn);
    posliSpravu(0x20,0xAA,dataSize1,aDataIn);
    }
    
    void led1onC()
{
    int aDataIn[] = {0x1};
    int dataSize1 = ARRAY_SIZE(aDataIn);
    posliSpravu(0x21,0xAA,dataSize1,aDataIn);
    }
    
    void led2onC()
{
    int aDataIn[] = {0x1};
    int dataSize1 = ARRAY_SIZE(aDataIn);
    posliSpravu(0x22,0xAA,dataSize1,aDataIn);
    }
    
    void led3onC()
{
    int aDataIn[] = {0x1};
    int dataSize1 = ARRAY_SIZE(aDataIn);
    posliSpravu(0x23,0xAA,dataSize1,aDataIn);
    }
    
    void led4onC()
{
    int aDataIn[] = {0x1};
    int dataSize1 = ARRAY_SIZE(aDataIn);
    posliSpravu(0x24,0xAA,dataSize1,aDataIn);
    }
    
    
    
    void ledPoffC()
{
    int aDataIn[] = {0x0};
    int dataSize1 = ARRAY_SIZE(aDataIn);
    posliSpravu(0x20,0xAA,dataSize1,aDataIn);
    }
    
    void led1offC()
{
    int aDataIn[] = {0x0};
    int dataSize1 = ARRAY_SIZE(aDataIn);
    posliSpravu(0x21,0xAA,dataSize1,aDataIn);
    }
    
    void led2offC()
{
    int aDataIn[] = {0x0};
    int dataSize1 = ARRAY_SIZE(aDataIn);
    posliSpravu(0x22,0xAA,dataSize1,aDataIn);
    }
    
    void led3offC()
{
    int aDataIn[] = {0x0};
    int dataSize1 = ARRAY_SIZE(aDataIn);
    posliSpravu(0x23,0xAA,dataSize1,aDataIn);
    }
    
    void led4offC()
{
    int aDataIn[] = {0x0};
    int dataSize1 = ARRAY_SIZE(aDataIn);
    posliSpravu(0x24,0xAA,dataSize1,aDataIn);
    }
    