#include "mbed.h" 

extern Serial pc;

#ifndef __DEBUG__
    #define __DEBUG__ 0
    #define Level 1
    #define DBG(x, ...) if (Level>=3) debug("[DBG]"x"\r\n", ##__VA_ARGS__); 
    #define WARN(x, ...) if (Level>=2) debug("[WARN]"x"\r\n", ##__VA_ARGS__); 
    #define ERR(x, ...) if (Level>=1) debug("[ERR]"x"\r\n", ##__VA_ARGS__); 
#endif

#define NO_STM8 0   //set to 1 if STM8 has been removed from the CPL board

extern unsigned short maison;

typedef enum {
    Moon   = 0,
    Conf1  = 1, // Confort -2
    Conf2  = 2, // Confort -1
    Sun    = 3,
    ABS    = 4,
    HG     = 7, // Abs with prog = Sun
    OFF    = 8,
    OFF2   = 0x0B // Off with prog = Sun
}h_mode;  //Heater mode
// mode | 0x08 => OFF
// mode | 0x04 => Abs

typedef struct {
    long v;
    bool pin;
}pulse_t;

typedef struct {
    unsigned char data[14];
    int length;
}msg_t;

typedef struct {
    char name[32];
    h_mode mode;
    bool fixed;
    unsigned char associated;
}zone_t;



void Init_X2D(void);
//void TASK_RcvMessages(info_t *message);
void SendCmd(int zone, h_mode prog);
void SendAssoc(int zone, int delest);
//void write_ctrl_reg(unsigned long write_data);
//unsigned long read_ctrl_reg(void);
