#ifndef __DEBUG__
    #define __DEBUG__ 0
    #define Level 1
    #define DBG(x, ...) if (Level>=3) debug("[DBG]"x"\r\n", ##__VA_ARGS__); 
    #define WARN(x, ...) if (Level>=2) debug("[WARN]"x"\r\n", ##__VA_ARGS__); 
    #define ERR(x, ...) if (Level>=1) debug("[ERR]"x"\r\n", ##__VA_ARGS__); 
#endif

#define BUF_SIZE 1024

#define NB_CHAN 3

typedef struct {
    char deviceID;
    unsigned long timestamp;
    float hum1;
    float temp1;
    float hum2;
    float temp2;
    unsigned char pwm;
    int speed;
}measure_t;

void Init_Oregon(void);
void RF_Active(void);
void RF_StdBy(void);
